/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web;

import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.enums.SecurityIn;
import de.kosmos_lab.kosmos.annotations.enums.SecurityType;
import de.kosmos_lab.kosmos.annotations.info.Contact;
import de.kosmos_lab.kosmos.annotations.info.Info;
import de.kosmos_lab.kosmos.annotations.info.License;
import de.kosmos_lab.kosmos.annotations.media.ObjectSchema;
import de.kosmos_lab.kosmos.annotations.media.ObjectSchemas;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.media.Schemas;
import de.kosmos_lab.kosmos.annotations.security.SecuritySchema;
import de.kosmos_lab.kosmos.annotations.security.SecuritySchemas;
import de.kosmos_lab.kosmos.annotations.servers.Server;
import de.kosmos_lab.kosmos.annotations.servers.Servers;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.OpenApiParser;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.rules.RulesService;
import de.kosmos_lab.kosmos.platform.smarthome.CommandInterface;
import de.kosmos_lab.kosmos.platform.smarthome.CommandSourceName;
import de.kosmos_lab.kosmos.platform.web.KosmoSWebSocketService;
import de.kosmos_lab.kosmos.platform.web.KosmosWebSocketCreator;
import de.kosmos_lab.kosmos.platform.web.WebSocketService;
import de.kosmos_lab.kosmos.platform.web.servlets.KosmoSServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.WebServlet;
import jakarta.websocket.server.ServerEndpoint;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Info(description="# Kosmos Platform Synchron HTTP API \n### [Asyncron WS/MQTT Documentation](async.html) \nThis is the OpenAPI 3.0 specifaction for KosmoS, it can be found on https://kosmos-lab.de/doc/openapi.yaml \nPlease make sure you are logged in if you want to try to execute any request to the server.\nYou can simply login with the form injected to the top of the page.\n(Almost) all POST requests with simple a datatype for parameters can be used either with parameters in query or a JSONObject in the request body. Exceptions are more complex datatypes like JSONObjects themselves (for example for /schema/add).", title="KosmoS OpenAPI", version="filled-by-code", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0.html"), contact=@Contact(name="Jan Janssen", email="Jan.Janssen@dfki.de"))
@SecuritySchemas(value={@SecuritySchema(componentName="bearerAuth", description="contains a JSON Web Tokens (JWT) obtainable from #post-/user/login", type=SecurityType.HTTP, bearerFormat="JWT", scheme="bearer"), @SecuritySchema(componentName="secret", name="token", description="Contains a secret known to both parties", type=SecurityType.APIKEY, in=SecurityIn.QUERY)})
@ObjectSchemas(value={@ObjectSchema(componentName="groupNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the group", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the group", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="scopeNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the scope", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the scope", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="userNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the user", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the user", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="objectID", properties={@SchemaProperty(name="id", schema=@Schema(description="The ID", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="nameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID", type=SchemaType.INTEGER, required=true))})})
@Schemas(value={@Schema(name="userID", type=SchemaType.INTEGER, description="The ID of a user"), @Schema(name="userName", type=SchemaType.STRING, description="The name of a user"), @Schema(name="scopeID", type=SchemaType.INTEGER, description="The ID of a scope"), @Schema(name="scopeName", type=SchemaType.STRING, description="The name of a scope"), @Schema(name="groupID", type=SchemaType.INTEGER, description="The ID of a group"), @Schema(name="groupName", type=SchemaType.STRING, description="The name of a group")})
@Servers(value={@Server(description="Current Host", url="http://none/ #ignore this"), @Server(description="Local Test", url="http://localhost:18080"), @Server(description="Production", url="https://example.cloud:18081")})
public class WebServer
implements CommandInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebServer");
    private final IController controller;
    private final org.eclipse.jetty.server.Server server;
    private final int port;
    private final ServletContextHandler context;
    HashSet<Class<? extends KosmoSServlet>> loadedServlets = new HashSet();
    private KosmoSWebSocketService webSocketService = null;
    private boolean stopped = false;

    public WebServer(IController controller) {
        ServletContextHandler servletContextHandler;
        this.controller = controller;
        int maxThreads = 10;
        int minThreads = 2;
        int idleTimeout = 120;
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        JSONObject webserverConfig = controller.getConfig().getJSONObject("webserver");
        this.server = new org.eclipse.jetty.server.Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        this.port = webserverConfig.getInt("port");
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.context = servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        ServletHolder staticFiles = new ServletHolder("default", (Servlet)new DefaultServlet());
        staticFiles.setInitParameter("resourceBase", "./web/");
        staticFiles.setInitParameter("dirAllowed", "false");
        servletContextHandler.addServlet(staticFiles, "/*");
        HashSet<String> paths = new HashSet<String>();
        HashSet<Class> servlets = new HashSet<Class>();
        HashSet<Class> wsservices = new HashSet<Class>();
        for (Reflections r : new Reflections[]{new Reflections("", new Scanner[0]), new Reflections("de.kosmos_lab.kosmos.platform.web", new Scanner[0])}) {
            for (Class c : r.getSubTypesOf(WebSocketService.class)) {
                if (wsservices.contains(c)) continue;
                logger.info("Reflections found WebSocketService: {}", (Object)c.getName());
                wsservices.add(c);
            }
            for (Class c : r.getSubTypesOf(KosmoSServlet.class)) {
                if (servlets.contains(c)) continue;
                logger.info("Reflections found KosmoSServlet: {}", (Object)c.getName());
                servlets.add(c);
            }
            for (Class c : controller.getPluginManager().getClassesFor(WebSocketService.class)) {
                if (wsservices.contains(c)) continue;
                logger.info("PMM found WebSocketService: {}", (Object)c.getName());
                wsservices.add(c);
            }
            for (Class c : controller.getPluginManager().getClassesFor(KosmoSServlet.class)) {
                if (servlets.contains(c)) continue;
                logger.info("PMM found KosmoSServlet: {}", (Object)c.getName());
                servlets.add(c);
            }
            for (Class c : r.getTypesAnnotatedWith(ServerEndpoint.class)) {
                if (c.isAssignableFrom(WebSocketService.class) && !wsservices.contains(c)) {
                    logger.info("Annotations found WebSocketService: {}", (Object)c.getName());
                    wsservices.add(c);
                }
                if (!WebSocketService.class.isAssignableFrom(c) || wsservices.contains(c)) continue;
                logger.info("Annotations2 found WebSocketService: {}", (Object)c.getName());
                wsservices.add(c);
            }
            for (Class c : r.getTypesAnnotatedWith(ApiEndpoint.class)) {
                if (c.isAssignableFrom(KosmoSServlet.class) && !servlets.contains(c)) {
                    logger.info("Annotations found KosmoSServlet: {}", (Object)c.getName());
                    servlets.add(c);
                }
                if (!KosmoSServlet.class.isAssignableFrom(c) || servlets.contains(c)) continue;
                logger.info("Annotations2 found KosmoSServlet: {}", (Object)c.getName());
                servlets.add(c);
            }
            for (Class c : r.getTypesAnnotatedWith(WebServlet.class)) {
                if (c.isAssignableFrom(KosmoSServlet.class) && !servlets.contains(c)) {
                    logger.info("Annotations3 found KosmoSServlet: {}", (Object)c.getName());
                    servlets.add(c);
                }
                if (!KosmoSServlet.class.isAssignableFrom(c) || servlets.contains(c)) continue;
                logger.info("Annotations4 found KosmoSServlet: {}", (Object)c.getName());
                servlets.add(c);
            }
        }
        for (Class c : servlets) {
            WebServlet f;
            ApiEndpoint api = c.getAnnotation(ApiEndpoint.class);
            if (api != null) {
                try {
                    if (paths.contains(api.path())) continue;
                    KosmoSServlet s = api.userLevel() >= 0 ? (KosmoSServlet)((Object)c.getConstructor(WebServer.class, IController.class, Integer.TYPE).newInstance(this, controller, api.userLevel())) : (KosmoSServlet)((Object)c.getConstructor(WebServer.class, IController.class).newInstance(this, controller));
                    servletContextHandler.addServlet(new ServletHolder((Servlet)s), api.path());
                    this.loadedServlets.add(c);
                    paths.add(api.path());
                    logger.info("registered web servlet {} ", ((Object)((Object)s)).getClass());
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if ((f = c.getAnnotation(WebServlet.class)) == null) continue;
            try {
                KosmoSServlet s = (KosmoSServlet)((Object)c.getConstructor(WebServer.class, IController.class).newInstance(this, controller));
                for (String url : f.urlPatterns()) {
                    if (paths.contains(url)) continue;
                    servletContextHandler.addServlet(new ServletHolder((Servlet)s), url);
                    paths.add(url);
                    this.loadedServlets.add(c);
                    logger.info("registered web servlet {} ", ((Object)((Object)s)).getClass());
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        try {
            this.webSocketService = new KosmoSWebSocketService(this, controller);
            JettyWebSocketServlet websocketServlet = new JettyWebSocketServlet(){

                protected void configure(JettyWebSocketServletFactory factory) {
                    factory.setCreator((JettyWebSocketCreator)new KosmosWebSocketCreator(WebServer.this.webSocketService, null));
                }
            };
            wsservices.remove(KosmoSWebSocketService.class);
            servletContextHandler.addServlet(new ServletHolder((Servlet)websocketServlet), this.webSocketService.getClass().getAnnotation(ServerEndpoint.class).value());
            if (this.getRulesService() != null) {
                websocketServlet = new JettyWebSocketServlet(){

                    protected void configure(JettyWebSocketServletFactory factory) {
                        factory.setIdleTimeout(Duration.ofSeconds(60L));
                        factory.setCreator((JettyWebSocketCreator)new KosmosWebSocketCreator(WebServer.this.getRulesService(), null));
                    }
                };
                servletContextHandler.addServlet(new ServletHolder((Servlet)websocketServlet), this.getRulesService().getClass().getAnnotation(ServerEndpoint.class).value());
                wsservices.remove(this.getRulesService().getClass());
            }
            for (Class c : wsservices) {
                ServerEndpoint endpoint = c.getAnnotation(ServerEndpoint.class);
                logger.info("found: WebSocketService: {} endpoint {}", (Object)c.getName(), (Object)endpoint.value());
                if (endpoint == null) continue;
                try {
                    final WebSocketService service = (WebSocketService)c.getConstructor(WebServer.class, IController.class).newInstance(this, controller);
                    websocketServlet = new JettyWebSocketServlet(){

                        protected void configure(JettyWebSocketServletFactory factory) {
                            factory.setIdleTimeout(Duration.ofSeconds(60L));
                            factory.setCreator((JettyWebSocketCreator)new KosmosWebSocketCreator(service, null));
                        }
                    };
                    servletContextHandler.addServlet(new ServletHolder((Servlet)websocketServlet), endpoint.value());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContextHandler, null);
            handlers.addHandler((Handler)servletContextHandler);
            this.server.setHandler((Handler)handlers);
            OpenApiParser.create(this.loadedServlets);
            this.server.start();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        controller.addCommandInterface(this);
    }

    private static ContextHandler createContextHandler(String contextPath, Handler wrappedHandler) {
        ContextHandler ch = new ContextHandler(contextPath);
        ch.setHandler(wrappedHandler);
        ch.clearAliasChecks();
        ch.setAllowNullPathInfo(true);
        return ch;
    }

    public HashSet<Class<? extends KosmoSServlet>> getLoadedServlets() {
        return this.loadedServlets;
    }

    public IController getIController() {
        return this.controller;
    }

    public int getPort() {
        return this.port;
    }

    public RulesService getRulesService() {
        return this.controller.getRulesService();
    }

    @Override
    public String getSourceName() {
        return "HTTPApi";
    }

    @Override
    public void deviceAdded(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
    }

    @Override
    public void deviceRemoved(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
    }

    @Override
    public void deviceUpdate(@Nullable CommandInterface from, @Nonnull Device device, @Nullable String key, @Nonnull CommandSourceName source) {
    }

    @Override
    public void stop() {
        try {
            this.stopped = true;
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "WebServer";
    }

    public KosmoSWebSocketService getWebSocketService() {
        return this.webSocketService;
    }

    public void addStaticFile(File f, String name) {
        ServletHolder staticFiles = new ServletHolder("default", (Servlet)new DefaultServlet());
        staticFiles.setInitParameter("resourceBase", "./web/");
        this.context.addServlet(staticFiles, "/*");
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

