/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets;

import de.dfki.baall.helper.webserver.JWT;
import de.dfki.baall.helper.webserver.data.IUser;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.smarthome.CommandSourceName;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.KosmoSServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.json.JSONObject;

public abstract class AuthedServlet
extends KosmoSServlet {
    protected final int level;

    public AuthedServlet(WebServer webServer, IController controller) {
        this(webServer, controller, 1);
    }

    public AuthedServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller);
        this.level = level;
    }

    protected CommandSourceName getSource(KosmoSHttpServletRequest request) {
        if (this.controller != null) {
            try {
                IUser u = request.getKosmoSUser();
                return this.controller.getSource("HTTPApi:" + u.getName());
            }
            catch (Exception exception) {
                return this.controller.getSource("HTTPApi");
            }
        }
        return null;
    }

    @Override
    protected boolean isAllowed(HttpServletRequest request, HttpServletResponse response) {
        String auth = request.getHeader("Authorization");
        if (auth != null) {
            IUser u;
            auth = auth.trim();
            try {
                String[] t;
                if (auth.startsWith("Basic") && (t = new String(Base64.getDecoder().decode(auth.substring(5).trim())).split(":")).length == 2 && (u = this.controller.tryLogin(t[0], t[1])) != null) {
                    request.setAttribute("user", (Object)u);
                    if (u.canAccess(this.level)) {
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                logger.info("Exception while parsing basic: ", (Throwable)ex);
            }
            if (auth.startsWith("Bearer")) {
                auth = auth.substring(6).trim();
            }
            try {
                JSONObject s = this.controller.getJwt().verify(auth);
                u = this.controller.getUser(s.getString("name"));
                request.setAttribute("user", (Object)u);
                if (u.canAccess(this.level)) {
                    return true;
                }
                response.setStatus(403);
                return false;
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (JWT.JWTVerifyFailed e) {
                // empty catch block
            }
        }
        if (this.allow_auth == KosmoSServlet.ALLOW_AUTH.PARAMETER_AND_HEADER) {
            IUser u;
            String username = request.getHeader("username");
            String password = request.getHeader("password");
            if (username == null || password == null) {
                username = request.getParameter("username");
                password = request.getParameter("password");
            }
            if (username != null && password != null && (u = this.controller.tryLogin(username, password)) != null) {
                request.setAttribute("user", (Object)u);
                if (u.canAccess(this.level)) {
                    return true;
                }
            }
        }
        response.setHeader("WWW-Authenticate", "Bearer realm=\"example\",\n                   error=\"invalid_token\",\n                   error_description=\"The access token expired\"");
        response.setStatus(401);
        return false;
    }

    protected boolean isMeOrAmAdmin(KosmoSHttpServletRequest request, IUser u) {
        IUser me = request.getKosmoSUser();
        logger.warn(me.toJWT() + " vs " + u.toJWT());
        if (me.getUUID().getLeastSignificantBits() == u.getUUID().getLeastSignificantBits()) {
            return true;
        }
        return me.isAdmin() && me.getLevel() >= u.getLevel();
    }
}

