/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets;

import de.dfki.baall.helper.persistence.exceptions.AlreadyExistsException;
import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.doc.openapi.ApiResponseDescription;
import de.kosmos_lab.kosmos.exceptions.NoAccessException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToGroup;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotFoundException;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import org.everit.json.schema.ValidationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KosmoSServlet
extends HttpServlet {
    final ALLOW_AUTH allow_auth;
    protected static final Logger logger = LoggerFactory.getLogger((String)"KosmoSServlet");
    public static final int STATUS_OK = 200;
    public static final int STATUS_NO_RESPONSE = 204;
    @ApiResponseDescription(name="NoAccessError", description="The request was aborted because your user does not have the correct privileges to execute the request.")
    public static final int STATUS_FORBIDDEN = 403;
    @ApiResponseDescription(name="ValidationFailedError", description="The request was aborted because the payload could not be verified against the schema.  \nSee errormessage for details")
    public static final int STATUS_VALIDATION_FAILED = 400;
    @ApiResponseDescription(name="DuplicateError", description="The request was aborted because there was already a resource with that identifier.  \nSee errormessage for details")
    public static final int STATUS_DUPLICATE = 409;
    @ApiResponseDescription(name="FailedError", description="The request was aborted.  \nSee errormessage for details ")
    public static final int STATUS_FAILED = 400;
    @ApiResponseDescription(name="NoAuthError", description="This endpoint only works with authentication")
    public static final int STATUS_NO_AUTH = 401;
    @ApiResponseDescription(name="NotFoundError", description="The searched resource was not found  \nSee errormessage for details")
    public static final int STATUS_NOT_FOUND = 404;
    @ApiResponseDescription(name="ConflictError", description="The request was aborted because there was already a resource with that identifier.  \nSee errormessage for details")
    public static final int STATUS_CONFLICT = 409;
    @ApiResponseDescription(name="UnproccessableError", description="The request could not be processed, are all required properties/parameters filled?  \nSee errormessage for details")
    public static final int STATUS_UNPROCESSABLE = 422;
    @ApiResponseDescription(name="MissingValuesError", description="The request could not be processed, are all required properties/parameters filled?  \nSee errormessage for details")
    public static final int STATUS_MISSING_VALUE = 422;
    @ApiResponseDescription(name="UnknownError", description="The server ran into an error while processing the request")
    public static final int STATUS_ERROR = 500;
    @ApiResponseDescription(name="MethodNotAllowedError", description="The requested HTTP-method is not valid for this endpoint")
    public static final int STATUS_METHOD_NOT_ALLOWED = 405;
    protected final IController controller;
    protected final WebServer server;

    public KosmoSServlet(WebServer server, IController controller) {
        this(server, controller, ALLOW_AUTH.PARAMETER_AND_HEADER);
    }

    public KosmoSServlet(WebServer server, IController controller, ALLOW_AUTH allow_auth) {
        this.server = server;
        this.controller = controller;
        this.allow_auth = allow_auth;
        logger.info("created servlet {}", ((Object)((Object)this)).getClass());
    }

    protected void addCORSHeader(HttpServletRequest req, HttpServletResponse response) {
        String origin = req.getHeader("Origin");
        origin = origin == null || origin.length() == 0 ? "*" : URLEncoder.encode(origin, StandardCharsets.UTF_8);
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Cache-Control");
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    protected boolean checkParameter(HttpServletRequest req, HttpServletResponse response, String[] keys) throws IOException {
        Enumeration it = req.getParameterNames();
        HashMap<String, Boolean> missing = new HashMap<String, Boolean>();
        for (String k : keys) {
            missing.put(k, true);
        }
        while (it.hasMoreElements()) {
            String e = (String)it.nextElement();
            missing.remove(e);
        }
        if (!missing.isEmpty()) {
            response.setStatus(400);
            PrintWriter w = response.getWriter();
            for (String k : missing.keySet()) {
                w.println("missing parameter '" + k + "'");
            }
            return false;
        }
        return true;
    }

    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessToScope, NoAccessToGroup {
        response.setStatus(405);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.delete(new KosmoSHttpServletRequest(request), response);
            }
            catch (NotObjectSchemaException e) {
                response.setStatus(400);
                response.getWriter().print("not object schema");
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (NoAccessException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (ValidationException e) {
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.get(new KosmoSHttpServletRequest(request), response);
            }
            catch (NotObjectSchemaException e) {
                response.setStatus(400);
                response.getWriter().print("not object schema");
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (ValidationException e) {
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
            }
            catch (NoAccessException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.addCORSHeader(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.post(new KosmoSHttpServletRequest(request), response);
            }
            catch (NotObjectSchemaException e) {
                response.setStatus(400);
                response.getWriter().print("not object schema");
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (NoAccessException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (ValidationException e) {
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
            }
            catch (AlreadyExistsException e) {
                response.setStatus(409);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doPut(request, response);
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.put(new KosmoSHttpServletRequest(request), response);
            }
            catch (NotObjectSchemaException e) {
                response.setStatus(400);
                response.getWriter().print("not object schema");
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (ValidationException e) {
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
            }
            catch (NoAccessException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessException, NotFoundInPersistenceException {
        response.setStatus(405);
    }

    protected boolean isAllowed(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public void options(KosmoSHttpServletRequest request, HttpServletResponse response) {
        response.setStatus(200);
        this.addCORSHeader(request.getRequest(), response);
    }

    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessToScope, NoAccessToGroup, NotFoundInPersistenceException, AlreadyExistsException {
        response.setStatus(405);
    }

    public void put(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessToScope, NoAccessToGroup {
        response.setStatus(405);
    }

    public static void sendJSON(KosmoSHttpServletRequest req, HttpServletResponse response, JSONObject obj) throws IOException {
        response.setHeader("Content-Type", "application/json");
        try {
            String p = req.getParameter("pretty");
            if ("1".equals(p)) {
                response.getWriter().print(obj.toString(4));
            } else {
                response.getWriter().print(obj.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            response.getWriter().print(obj.toString());
        }
    }

    public static void sendJSON(KosmoSHttpServletRequest req, HttpServletResponse response, JSONArray obj) throws IOException {
        response.setHeader("Content-Type", "application/json");
        try {
            String p = req.getParameter("pretty");
            if ("1".equals(p)) {
                response.getWriter().print(obj.toString(4));
            } else {
                response.getWriter().print(obj.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            response.getWriter().print(obj.toString());
        }
    }

    public static void sendJWT(KosmoSHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "application/jwt");
        response.getWriter().print(text);
    }

    public static void sendText(KosmoSHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "text/plain");
        response.getWriter().print(text);
    }

    public static void sendHTML(KosmoSHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "text/html");
        response.getWriter().print(text);
    }

    public static void sendXML(KosmoSHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "application/xml");
        response.getWriter().print(text);
    }

    public static enum ALLOW_AUTH {
        HEADER_ONLY,
        PARAMETER_AND_HEADER;

    }
}

