/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.camera;

import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.CameraNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import de.kosmos_lab.platform.plugins.camera.ICamera;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/camera/snapshot", userLevel=1)
public class CameraSnapshotServlet
extends AuthedServlet {
    private static final String FIELD_CAMERA = "camera";
    private static final String FIELD_HEIGHT = "height";
    private static final String FIELD_WIDTH = "width";

    public CameraSnapshotServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"camera"}, summary="get snapshot", description="Get a current snapshot from the camera", parameters={@Parameter(description="The name of the camera", in=ParameterIn.QUERY, name="camera", schema=@Schema(type=SchemaType.STRING), required=true), @Parameter(description="The maximum height in pixels you want to have the image returned in", in=ParameterIn.QUERY, name="height", schema=@Schema(type=SchemaType.INTEGER, defaultValue="0"), required=false), @Parameter(description="The maximum width in pixels you want to have the image returned in", in=ParameterIn.QUERY, name="width", schema=@Schema(type=SchemaType.INTEGER, defaultValue="0"), required=false)}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), content={@Content(mediaType="image/*")}, description="An actual image to display"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/CameraNotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, CameraNotFoundException, ParameterNotFoundException {
        String cameraName = request.getParameter(FIELD_CAMERA, true);
        ICamera cam = this.controller.getCamera(cameraName);
        int width = request.getInt(FIELD_WIDTH, 0);
        int height = request.getInt(FIELD_HEIGHT, 0);
        byte[] content = height != 0 && width != 0 ? cam.getSnapshot(width, height) : cam.getSnapshot();
        try {
            response.getOutputStream().write(content);
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ex) {
            logger.error("exception while parsing camera {}", (Object)ex.getMessage(), (Object)ex);
            return;
        }
    }
}

