/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.device;

import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.DeviceNotFoundException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;

@ApiEndpoint(path="/device/locations", userLevel=1)
public class DeviceLocationsServlet
extends AuthedServlet {
    public DeviceLocationsServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"device"}, summary="locations", description="Get the locations of all device you have access to", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="A JSONObject with name value pairs of devices and its locations", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, additionalProperties="{\"$ref\": \"#/components/schemas/deviceLocation\"}"), examples={@ExampleObject(name="example", value="{\"light1\":{\"x\":10,\"y\":124,\"z\":24,\"area\":\"livingroom\"},\"light2\":{\"x\":145,\"y\":125,\"z\":125,\"roll\":12,\"pitch\":24,\"yaw\":46,\"w\":10,\"d\":10,\"h\":10,\"area\":\"bedroom\"}}")})}), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, NoAccessToScope, DeviceNotFoundException, ParameterNotFoundException {
        JSONObject json = new JSONObject();
        for (Device device : this.controller.getAllDevices()) {
            try {
                Device.Location loc;
                IUser user = request.getKosmoSUser();
                if (!device.canRead(user) || (loc = device.getLocation()) == null) continue;
                json.put(device.getUniqueID(), (Object)loc.toJSON());
            }
            catch (NoAccessToScope noAccessToScope) {}
        }
        DeviceLocationsServlet.sendJSON(request, response, json);
    }
}

