/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.gesture;

import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.NotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import de.kosmos_lab.kosmos.platform.web.servlets.gesture.GestureListServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/gesture/delete", userLevel=1)
public class GestureDeleteServlet
extends AuthedServlet {
    public GestureDeleteServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"device"}, summary="delete", description="Delete a gesture from the system.", parameters={@Parameter(name="id", in=ParameterIn.QUERY, schema=@Schema(description="The uuid of the device to delete", type=SchemaType.STRING, minLength=3, required=true))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The gesture was added successfully", ref="#/components/responses/gestureList"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), description="This gestures was not found"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException, NotFoundException {
        String id = request.getString("id");
        if (this.controller.getGestureProvider().deleteGesture(id)) {
            GestureDeleteServlet.sendJSON(request, response, GestureListServlet.getGestureList(this.controller));
            return;
        }
        throw new NotFoundException("Gesture " + id + " was not found");
    }
}

