/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.group;

import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(urlPatterns={"/group/add"}, loadOnStartup=1)
public class GroupAddServlet
extends AuthedServlet {
    public static final String FIELD_NAME = "name";

    public GroupAddServlet(WebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"group"}, summary="add", description="Create a new group", requestBody=@RequestBody(required=true, content={@Content(examples={@ExampleObject(name="add group with name 'testGroup'", value="{\"name\":\"testGroup\"}")}, mediaType="application/json", schemaProperties={@SchemaProperty(name="name", schema=@Schema(description="name of the new group.", type=SchemaType.STRING, minLength=3, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/scopeGet", description="The group was added successfully"), @ApiResponse(responseCode=@ResponseCode(statusCode=409), description="There is already a group with that name."), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope, ParameterNotFoundException {
        String group_name = request.getString(FIELD_NAME);
        if (group_name.length() < 3) {
            response.sendError(422, "group name is not long enough (minLength is 3)");
            return;
        }
        try {
            this.controller.addGroup(group_name, request.getKosmoSUser());
        }
        catch (GroupAlreadyExistsException ex) {
            response.setStatus(409);
            return;
        }
        response.setStatus(204);
    }
}

