/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.group;

import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Group;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.NoAccessToGroup;
import de.kosmos_lab.kosmos.exceptions.NotFoundException;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.UserNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(urlPatterns={"/group/deladmin"}, loadOnStartup=1)
public class GroupDelAdminServlet
extends AuthedServlet {
    public static final String FIELD_GROUP = "group";
    public static final String FIELD_USER = "user";

    public GroupDelAdminServlet(WebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"scope"}, summary="delete admin", description="delete an admin from the group.", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="group", schema=@Schema(description="The group from which to remove the user", type=SchemaType.STRING, required=true)), @SchemaProperty(name="user", schema=@Schema(description="The username of the user to delete from the group", type=SchemaType.STRING, required=true))}, examples={@ExampleObject(name="add user 'testUser' to scope 'testGroup'", value="{\"group\":\"testGroup\",\"user\":\"testUser\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The user was removed from the group successfully."), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, NotFoundInPersistenceException, NoAccessToGroup, NotFoundException, ParameterNotFoundException {
        String sname = request.getString(FIELD_GROUP);
        String uname = request.getString(FIELD_USER);
        Group group = this.controller.getGroup(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
        if (group.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
            IUser u = this.controller.getUser(uname);
            if (u != null) {
                this.controller.delGroupAdmin(group, u);
                response.setStatus(204);
                return;
            }
            throw new UserNotFoundException(uname);
        }
        throw new NoAccessToGroup(group);
    }
}

