/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.group;

import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.ArraySchema;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Group;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.GroupNotFoundException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiResponse(componentName="groupGet", responseCode=@ResponseCode(statusCode=204), description="Details about the group", content={@Content(mediaType="application/json", examples={@ExampleObject(name="testGroup", value="{\"name\":\"testGroup\",\"id\":18,\"users\":[{\"name\":\"user7\",\"id\":7}],\"admins\":[{\"name\":\"admin\",\"id\":1}]}")}, schemaProperties={@SchemaProperty(name="name", schema=@Schema(type=SchemaType.STRING, description="The name of the group")), @SchemaProperty(name="id", schema=@Schema(type=SchemaType.INTEGER, description="The ID of the group")), @SchemaProperty(name="admins", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with admin level access to the group", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="users", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with user level access to the group", ref="#/components/schemas/userNameID")))})})
@WebServlet(urlPatterns={"/group/get"}, loadOnStartup=1)
public class GroupGetServlet
extends AuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public GroupGetServlet(WebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"group"}, summary="get", description="get information about the group", parameters={@Parameter(description="The name of the group to get detail about. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the group to get detail about. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/groupGet"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope, NotFoundInPersistenceException, ParameterNotFoundException, GroupNotFoundException {
        try {
            String sname = request.getString(FIELD_NAME);
            if (sname != null) {
                Group group = this.controller.getGroup(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                GroupGetServlet.sendJSON(request, response, group.toJSON());
                return;
            }
        }
        catch (ParameterNotFoundException sname) {
            // empty catch block
        }
        Group group = this.controller.getGroup(request.getInt(FIELD_ID), Constants.CacheMode.CACHE_AND_PERSISTENCE);
        GroupGetServlet.sendJSON(request, response, group.toJSON());
    }
}

