/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.group;

import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.ArraySchema;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Group;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@WebServlet(urlPatterns={"/group/my"}, loadOnStartup=1)
public class GroupMyServlet
extends AuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_ADMIN = "admin";

    public GroupMyServlet(WebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"scope"}, summary="my", description="Lists the scopes you have access to", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="A JSONObject stating the groups you have access to", content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="admin", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the groups you have admin access to"))), @SchemaProperty(name="user", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the groups you have user access to")))})}), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope {
        JSONObject o = new JSONObject();
        JSONArray arr = new JSONArray();
        for (Group group : this.controller.getAllGroupsWithUser(request.getKosmoSUser())) {
            arr.put((Object)group.getName());
        }
        o.put(FIELD_USER, (Object)arr);
        arr = new JSONArray();
        for (Group group : this.controller.getAllGroupsWithAdmin(request.getKosmoSUser())) {
            arr.put((Object)group.getName());
        }
        o.put(FIELD_ADMIN, (Object)arr);
        GroupMyServlet.sendJSON(request, response, o);
    }
}

