/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.kree;

import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/kree/loadXML", userLevel=1)
public class KreeLoadXMLServlet
extends AuthedServlet {
    public KreeLoadXMLServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"kree"}, summary="load xml", description="loads the block xml back from persistence", requestBody=@RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="#/components/schemas/schema"))}), responses={@ApiResponse(description="XML Block definition", responseCode=@ResponseCode(statusCode=200), content={@Content(mediaType="application/xml")}), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException {
        String xml = this.server.getRulesService().getXML(request.getKosmoSUser());
        if (xml != null) {
            response.setStatus(200);
            KreeLoadXMLServlet.sendXML(request, response, xml);
            return;
        }
        KreeLoadXMLServlet.sendXML(request, response, "<xml xmlns=\"https://developers.google.com/blockly/xml\">\n</xml>");
    }
}

