/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.kree;

import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/kree/savePython", userLevel=1)
public class KreeSavePythonServlet
extends AuthedServlet {
    private static final String[] bad = new String[]{"open(", "load(", "loads("};
    private static final String[] badEnds = new String[0];
    private static final String[] badStarts = new String[0];
    private static final String[] allowedImports = new String[]{"import math", "import random", "from numbers import Number", "import os.path", "import sys", "from kosmos import *", "import threading", "import time"};

    public KreeSavePythonServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"kree"}, summary="save python", description="saves the block python to persistence and executes it", requestBody=@RequestBody(description="the python of the blocks", content={@Content(mediaType="application/xml")}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="Python saved successfully"), @ApiResponse(responseCode=@ResponseCode(statusCode=409), ref="The saving of this code was blocked - you are using unsafe code"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException {
        String python = request.getBody();
        if (python.length() > 0) {
            for (String l : python.split("\n")) {
                if ((l = l.trim()).contains("import ")) {
                    boolean isOk = false;
                    String[] stringArray = allowedImports;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String i2 = stringArray[i];
                        if (!l.equals(i2)) continue;
                        isOk = true;
                        break;
                    }
                    if (!isOk) {
                        response.setStatus(400);
                        return;
                    }
                }
                for (String b : bad) {
                    if (!l.contains(b)) continue;
                    response.setStatus(400);
                    return;
                }
                for (String b : badEnds) {
                    if (!l.endsWith(b)) continue;
                    response.setStatus(400);
                    return;
                }
                for (String b : badStarts) {
                    if (!l.startsWith(b)) continue;
                    response.setStatus(400);
                    return;
                }
            }
            this.server.getRulesService().savePython(request.getKosmoSUser(), python);
            response.setStatus(204);
            return;
        }
        response.setStatus(400);
    }
}

