/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.obs;

import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.Explode;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.ArraySchema;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.data.StateUpdates;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.DeviceNotFoundException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONObject;

@ApiEndpoint(path="/obs/live", userLevel=1)
public class OBSLiveServlet
extends AuthedServlet {
    public static final Long DEFAULT_MAX_AGE = 120000L;

    public OBSLiveServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"obs"}, summary="live", description="Get the information to show in OBS", parameters={@Parameter(in=ParameterIn.QUERY, name="uuid", required=true, description="A comma seperated list of all uuids you want to get the status of, does support wildcards", array=@ArraySchema(minItems=1, uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING)), explode=Explode.TRUE, examples={@ExampleObject(name="virt_sensor_temp_0,virt_sensor_temp_1", value="virt_sensor_temp_0,virt_sensor_temp_1"), @ExampleObject(name="virt_sensor_temp_0", value="virt_sensor_temp_0"), @ExampleObject(name="virt_sensor_temp_*", value="virt_sensor_temp_*"), @ExampleObject(name="*", value="*")}), @Parameter(name="type", in=ParameterIn.QUERY, schema=@Schema(description="The type to return back", type=SchemaType.STRING, allowableValues={"html", "json", "text"}, required=false, defaultValue="text")), @Parameter(name="maxAge", in=ParameterIn.QUERY, schema=@Schema(description="The maximum age of a change to show it", type=SchemaType.NUMBER, required=false, defaultValue="120000"))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="the wanted data", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, description="a name value pair with the changes that were seen in the timeframe, returned if type == 'json'"), examples={@ExampleObject(name="JSON Example", value="{\"virt_sensor_temp_0\":{\"currentEnvironmentTemperature\":{\"value\":17,\"age\":30445}},\"virt_sensor_temp_1\":{\"currentEnvironmentTemperature\":{\"value\":17,\"age\":19460}}}")}), @Content(mediaType="text/html", schema=@Schema(type=SchemaType.STRING, description="A HTML page showing the changes, returned if type == 'html'"), examples={@ExampleObject(name="JSON Example", value="<html>virt_sensor_temp_0:{\"currentEnvironmentTemperature\":17}<br>virt_sensor_temp_1:{\"currentEnvironmentTemperature\":17}<br></html>")}), @Content(mediaType="text/plain", schema=@Schema(type=SchemaType.STRING, description="A string showing the changes, returned if type == 'text'"), examples={@ExampleObject(name="JSON Example", value="virt_sensor_temp_0:{\"currentEnvironmentTemperature\":17}\nvirt_sensor_temp_1:{\"currentEnvironmentTemperature\":17}")})}), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, DeviceNotFoundException, ParameterNotFoundException, NoAccessToScope {
        String id = request.getUUID();
        String html = request.getString("html", null);
        boolean doHTML = html != null;
        String json = request.getString("json", null);
        boolean doJSON = json != null;
        String type = request.getString("type", null);
        if (type != null) {
            if (type.equals("json")) {
                doJSON = true;
            } else if (type.equals("html")) {
                doHTML = true;
            }
        }
        Long maxage = DEFAULT_MAX_AGE;
        try {
            String t = request.getString("maxAge", null);
            if (t != null && (maxage = Long.valueOf(Long.parseLong(t) * 1000L)) > DEFAULT_MAX_AGE) {
                maxage = DEFAULT_MAX_AGE;
            }
        }
        catch (NumberFormatException t) {
            // empty catch block
        }
        HashSet<String> uuids = new HashSet<String>();
        for (String u : id.split(",")) {
            if (u.contains("*")) {
                uuids.addAll(this.controller.getMatchingUUID(u));
                continue;
            }
            uuids.add(u);
        }
        HashMap<Device, StateUpdates> list = this.controller.getUpdates(uuids, maxage);
        if (doHTML) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (Map.Entry<Device, StateUpdates> entry : list.entrySet()) {
                HashMap<String, Long> map = entry.getValue().map;
                if (map.isEmpty()) continue;
                sb.append(entry.getKey().getName()).append(':');
                JSONObject o2 = new JSONObject();
                for (Map.Entry<String, Long> change : map.entrySet()) {
                    o2.put(change.getKey(), entry.getKey().get(change.getKey()));
                }
                sb.append(o2).append("<br>");
            }
            sb.append("</html>");
            OBSLiveServlet.sendHTML(request, response, sb.toString().trim());
        } else if (doJSON) {
            JSONObject j = new JSONObject();
            for (Map.Entry<Device, StateUpdates> entry : list.entrySet()) {
                JSONObject o2 = new JSONObject();
                HashMap<String, Long> map = entry.getValue().map;
                if (map.isEmpty()) continue;
                for (Map.Entry<String, Long> change : map.entrySet()) {
                    o2.put(change.getKey(), (Object)new JSONObject().put("value", entry.getKey().get(change.getKey())).put("age", (Object)change.getValue()));
                }
                j.put(entry.getKey().getUniqueID(), (Object)o2);
            }
            OBSLiveServlet.sendJSON(request, response, j);
        } else {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Device, StateUpdates> entry : list.entrySet()) {
                HashMap<String, Long> map = entry.getValue().map;
                if (map.isEmpty()) continue;
                sb.append(entry.getKey().getName()).append(':');
                JSONObject o2 = new JSONObject();
                for (Map.Entry<String, Long> change : map.entrySet()) {
                    o2.put(change.getKey(), entry.getKey().get(change.getKey()));
                }
                sb.append(o2).append('\n');
            }
            OBSLiveServlet.sendText(request, response, sb.toString().trim());
        }
    }
}

