/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.schreibtrainer;

import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.data.TimedList;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.KosmoSServlet;
import de.kosmos_lab.kosmos.platform.web.servlets.schreibtrainer.SchreibtrainerConstants;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

@ApiEndpoint(path="/schreibtrainer/clear", userLevel=1)
public class SchreibtrainerClearServlet
extends KosmoSServlet {
    public SchreibtrainerClearServlet(WebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"schreibtrainer"}, summary="clear", description="clear words from pen", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="uuid", schema=@Schema(description="The UUID of the pen to clear", type=SchemaType.STRING, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The pen was cleared successfully"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="The device has not the correct schema to be a pen")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ParameterNotFoundException {
        String uuid = request.getString("uuid");
        try {
            Device device = SchreibtrainerConstants.getDevice(this.controller, this.server, uuid);
            if (device.getSchema().getId().equalsIgnoreCase("https://kosmos-lab.de/schema/StabiloPen2.json")) {
                TimedList wl = SchreibtrainerConstants.getWordList(this.controller, this.server, device);
                wl.clear();
                device.updateFromJSON(this.server, new JSONObject().put("text", (Object)"").put("wordList", (Object)wl.toJSONArray()), this.controller.getSource("stabilo"));
                SchreibtrainerClearServlet.sendJSON(request, response, new JSONObject());
                return;
            }
            response.setStatus(422);
            SchreibtrainerClearServlet.sendText(request, response, "Device " + uuid + " does not have schema: https://kosmos-lab.de/schema/StabiloPen2.json");
            return;
        }
        catch (SchemaNotFoundException e) {
            e.printStackTrace();
        }
        catch (DeviceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
            return;
        }
        response.setStatus(500);
    }
}

