/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.scope;

import de.dfki.baall.helper.persistence.exceptions.AlreadyExistsException;
import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.ArraySchema;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Group;
import de.kosmos_lab.kosmos.data.Scope;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.GroupNotFoundException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.exceptions.ScopeAlreadyExistsException;
import de.kosmos_lab.kosmos.exceptions.UserNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiEndpoint(path="/scope/add", userLevel=1)
@WebServlet(urlPatterns={"/scope/add"}, loadOnStartup=1)
public class ScopeAddServlet
extends AuthedServlet {
    public ScopeAddServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="add", description="add a new scope", requestBody=@RequestBody(required=true, content={@Content(examples={@ExampleObject(name="add scope with name 'testScope'", value="{\"name\":\"testScope\"}"), @ExampleObject(name="add scope with name 'testScope2', and add user 7 as user and user 2 as admin", value="{\"name\":\"testScope2\",\"users\":[7],\"admins\":[2]}"), @ExampleObject(name="add scope with name 'testScope2', and add user 7 as user and user 2 as admin", value="{\"name\":\"testScope2\",\"users\":[7],\"admins\":[2]}")}, mediaType="application/json", schemaProperties={@SchemaProperty(name="name", schema=@Schema(description="name of the new scope.", type=SchemaType.STRING, minLength=3, required=true)), @SchemaProperty(name="users", array=@ArraySchema(schema=@Schema(description="an optional list of user names and/or user IDs to add as user to the new scope.", oneOfRef={"#/components/schemas/userID", "#/components/schemas/userName"}))), @SchemaProperty(name="admins", array=@ArraySchema(schema=@Schema(description="an optional list of user names and/or user IDs to add as admin to the new scope.", oneOfRef={"#/components/schemas/userID", "#/components/schemas/userName"}))), @SchemaProperty(name="userGroups", array=@ArraySchema(schema=@Schema(description="an optional list of user names and/or group IDs to add as admin to the new scope.", oneOfRef={"#/components/schemas/groupID", "#/components/schemas/groupName"}))), @SchemaProperty(name="adminGroups", array=@ArraySchema(schema=@Schema(description="an optional list of user names and/or group IDs to add as admin to the new scope.", oneOfRef={"#/components/schemas/groupID", "#/components/schemas/groupName"})))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/scopeGet", description="The scope was added successfully"), @ApiResponse(responseCode=@ResponseCode(statusCode=409), description="There is already a scope with that name."), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope, ParameterNotFoundException, AlreadyExistsException, GroupNotFoundException {
        String sname = request.getString("name");
        try {
            Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
            throw new ScopeAlreadyExistsException(sname);
        }
        catch (NotFoundInPersistenceException e) {
            Group g;
            Object utoken;
            int i;
            JSONArray users;
            Scope scope;
            block33: {
                IUser u;
                block32: {
                    scope = this.controller.addScope(sname, request.getKosmoSUser());
                    try {
                        users = request.getJSONArray("users");
                        if (users == null) break block32;
                        for (i = 0; i < users.length(); ++i) {
                            utoken = users.get(i);
                            if (utoken instanceof String && (u = this.controller.getUser(users.getString(i))) != null) {
                                scope.addUser(u);
                            }
                            if (utoken instanceof Integer) {
                                try {
                                    scope.addUser(this.controller.getUser(users.getInt(i)));
                                }
                                catch (UserNotFoundException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (!(utoken instanceof JSONObject)) continue;
                            try {
                                scope.addUser(this.controller.getUser(users.getJSONObject(i).getInt("id")));
                                continue;
                            }
                            catch (UserNotFoundException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    catch (ParameterNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    users = request.getJSONArray("admins");
                    if (users == null) break block33;
                    for (i = 0; i < users.length(); ++i) {
                        utoken = users.get(i);
                        if (utoken instanceof String && (u = this.controller.getUser(users.getString(i))) != null) {
                            scope.addAdmin(u);
                        }
                        if (utoken instanceof Integer) {
                            try {
                                scope.addAdmin(this.controller.getUser(users.getInt(i)));
                            }
                            catch (UserNotFoundException ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (!(utoken instanceof JSONObject)) continue;
                        try {
                            scope.addAdmin(this.controller.getUser(users.getJSONObject(i).getInt("id")));
                            continue;
                        }
                        catch (UserNotFoundException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (ParameterNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                users = request.getJSONArray("adminGroups");
                if (users != null) {
                    for (i = 0; i < users.length(); ++i) {
                        utoken = users.get(i);
                        if (utoken instanceof String && (g = this.controller.getGroup(users.getString(i), Constants.CacheMode.CACHE_AND_PERSISTENCE)) != null) {
                            scope.addAdminGroup(g);
                        }
                        if (utoken instanceof Integer) {
                            scope.addAdminGroup(this.controller.getGroup(users.getInt(i), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                        }
                        if (!(utoken instanceof JSONObject)) continue;
                        scope.addAdminGroup(this.controller.getGroup(users.getJSONObject(i).getInt("id"), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                    }
                }
            }
            catch (ParameterNotFoundException ex) {
                ex.printStackTrace();
            }
            try {
                users = request.getJSONArray("userGroups");
                if (users != null) {
                    for (i = 0; i < users.length(); ++i) {
                        utoken = users.get(i);
                        if (utoken instanceof String) {
                            g = this.controller.getGroup(users.getString(i), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                            scope.addUserGroup(g);
                        }
                        if (utoken instanceof Integer) {
                            scope.addUserGroup(this.controller.getGroup(users.getInt(i), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                        }
                        if (!(utoken instanceof JSONObject)) continue;
                        scope.addUserGroup(this.controller.getGroup(users.getJSONObject(i).getInt("id"), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                    }
                }
            }
            catch (ParameterNotFoundException ex) {
                ex.printStackTrace();
            }
            ScopeAddServlet.sendJSON(request, response, scope.toJSON());
            response.setStatus(200);
            return;
        }
    }
}

