/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.scope;

import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Scope;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.exceptions.ScopeNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/scope/delete", userLevel=1)
public class ScopeDeleteServlet
extends AuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public ScopeDeleteServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="delete", description="deletes a scope", parameters={@Parameter(description="The name of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The scope was deleted successfully."), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope, ScopeNotFoundException, ParameterNotFoundException {
        try {
            String sname = request.getString(FIELD_NAME);
            try {
                Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                if (scope.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
                    this.controller.deleteScope(scope);
                    response.setStatus(204);
                    return;
                }
                response.setStatus(403);
                return;
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException(sname);
            }
        }
        catch (ParameterNotFoundException sname) {
            try {
                int id = request.getInt(FIELD_ID);
                try {
                    Scope scope = this.controller.getScope(id, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (scope.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
                        this.controller.deleteScope(scope);
                        response.setStatus(204);
                        return;
                    }
                    response.setStatus(403);
                    return;
                }
                catch (NotFoundInPersistenceException ex) {
                    throw new ScopeNotFoundException("" + id);
                }
            }
            catch (ParameterNotFoundException ex) {
                ex.printStackTrace();
                response.setStatus(422);
                return;
            }
        }
    }
}

