/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.scope;

import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.ArraySchema;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.Scope;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.exceptions.ScopeNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/scope/get", userLevel=1)
@ApiResponse(componentName="scopeGet", responseCode=@ResponseCode(statusCode=204), description="Details about the scope", content={@Content(mediaType="application/json", examples={@ExampleObject(name="testScope", value="{\"name\":\"testScope\",\"id\":18,\"users\":[{\"name\":\"user7\",\"id\":7}],\"admins\":[{\"name\":\"admin\",\"id\":1}],\"adminGroups\":[],\"userGroups\":[{\"name\":\"testGroup2\",\"id\":2}]}")}, schemaProperties={@SchemaProperty(name="name", schema=@Schema(type=SchemaType.STRING, description="The name of the scope")), @SchemaProperty(name="id", schema=@Schema(type=SchemaType.INTEGER, description="The ID of the scope")), @SchemaProperty(name="admins", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with admin level access to the scope", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="users", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with user level access to the scope", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="userGroups", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of groups with user level access to the scope", ref="#/components/schemas/groupNameID"))), @SchemaProperty(name="adminGroups", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of groups with admin level access to the scope", ref="#/components/schemas/groupNameID")))})})
public class ScopeGetServlet
extends AuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public ScopeGetServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="get", description="get information about the scope", parameters={@Parameter(in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/scopeGet"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), ref="#/components/responses/NotFoundError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NotObjectSchemaException, SchemaNotFoundException, NoAccessToScope, NotFoundInPersistenceException, ScopeNotFoundException, ParameterNotFoundException {
        try {
            String sname = request.getString(FIELD_NAME);
            try {
                Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                ScopeGetServlet.sendJSON(request, response, scope.toJSON());
                return;
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException(sname);
            }
        }
        catch (ParameterNotFoundException sname) {
            int id = request.getInt(FIELD_ID);
            try {
                Scope scope = this.controller.getScope(id, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                ScopeGetServlet.sendJSON(request, response, scope.toJSON());
                return;
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException("" + id);
            }
        }
    }
}

