/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.user;

import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.data.KosmoSUser;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import de.kosmos_lab.utils.StringFunctions;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/user/add", userLevel=100)
public class UserAddServlet
extends AuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_PASS = "pass";
    private static final String FIELD_LEVEL = "level";

    public UserAddServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    public UserAddServlet(WebServer webServer, IController controller) {
        super(webServer, controller, 100);
    }

    @Override
    @Operation(tags={"user"}, summary="add", description="Add a user to the system.", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="user", schema=@Schema(description="The username of the new user.", type=SchemaType.STRING, minLength=3, required=true)), @SchemaProperty(name="pass", schema=@Schema(description="The password of the new user.", type=SchemaType.STRING, minLength=6, required=true)), @SchemaProperty(name="level", schema=@Schema(description="The level of the newly added user - must be less then your own level.", type=SchemaType.INTEGER, minimum="1", defaultValue="1", required=false))}, examples={@ExampleObject(name="add user testUser with level 1", value="{\"user\":\"testUser\",\"pass\":\"ksajfbaf\",\"level\":1}"), @ExampleObject(name="add user testUser2 with level 10", value="{\"user\":\"testUser2\",\"pass\":\"ksajfbaf\",\"level\":10}"), @ExampleObject(name="add user testUser2 with level 1", value="{\"user\":\"testUser3\",\"pass\":\"ksajfbaf\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="OK - user was added"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=409), description="Conflict - The user already exists"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=500), description="#/components/responses/FailedError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException {
        String user = request.getString(FIELD_USER);
        if (user.length() < 3) {
            response.sendError(422, "username is not long enough (minLength is 3)");
            return;
        }
        String pass = request.getString(FIELD_PASS);
        if (pass.length() < 6) {
            response.sendError(422, "password is not long enough (minLength is 6)");
            return;
        }
        int level = request.getInt(FIELD_LEVEL, 1);
        logger.info("trying to add user {} with level {}", (Object)user, (Object)level);
        IUser me = request.getKosmoSUser();
        if (level <= 0) {
            response.sendError(422, "The level is too low, minimum is 1");
        }
        if (level >= me.getLevel()) {
            response.sendError(403, String.format("You are not allowed to create a user with this level - maximum is %d", me.getLevel() - 1));
            return;
        }
        logger.info("going to add user {} with level {}", (Object)user, (Object)level);
        IUser u = this.controller.getUser(user);
        if (u == null) {
            logger.info("user is not yet taken {} with level {}", (Object)user, (Object)level);
            String salt = StringFunctions.generateRandomKey();
            String hash = this.controller.getPasswordHash(pass, salt);
            u = new KosmoSUser(this.controller, user, 0, level, hash, salt);
            this.controller.addUser(u);
            logger.info("finished adding user {} with level {}", (Object)user, (Object)level);
            response.setStatus(204);
            return;
        }
        response.sendError(409, "This user already exists!");
    }
}

