/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.user;

import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.Parameter;
import de.kosmos_lab.kosmos.annotations.enums.ParameterIn;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import jakarta.servlet.http.HttpServletResponse;

@ApiEndpoint(path="/user/delete", userLevel=100)
public class UserDelServlet
extends AuthedServlet {
    private static final String FIELD_USER = "user";

    public UserDelServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"user"}, summary="delete", description="This endpoint can be used to delete a user from the system.", parameters={@Parameter(name="user", in=ParameterIn.QUERY, schema=@Schema(description="The username of the user to delete", type=SchemaType.STRING, minLength=3, required=true))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="OK - user was deleted"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), description="The user could not be found"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=500), description="#/components/responses/FailedError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws ParameterNotFoundException {
        String user = request.getString(FIELD_USER);
        IUser u = this.controller.getUser(user);
        if (u == null) {
            response.setStatus(404);
            return;
        }
        IUser me = request.getKosmoSUser();
        if (u.getLevel() >= me.getLevel()) {
            response.setStatus(403);
            return;
        }
        this.controller.deleteUser(u);
        response.setStatus(204);
    }
}

