/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web.servlets.user;

import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.annotations.Operation;
import de.kosmos_lab.kosmos.annotations.enums.SchemaType;
import de.kosmos_lab.kosmos.annotations.media.Content;
import de.kosmos_lab.kosmos.annotations.media.ExampleObject;
import de.kosmos_lab.kosmos.annotations.media.Schema;
import de.kosmos_lab.kosmos.annotations.media.SchemaProperty;
import de.kosmos_lab.kosmos.annotations.parameters.RequestBody;
import de.kosmos_lab.kosmos.annotations.responses.ApiResponse;
import de.kosmos_lab.kosmos.doc.openapi.ApiEndpoint;
import de.kosmos_lab.kosmos.doc.openapi.ResponseCode;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.servlets.AuthedServlet;
import de.kosmos_lab.utils.StringFunctions;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/user/password", userLevel=1)
public class UserPasswordServlet
extends AuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_PASS = "pass";

    public UserPasswordServlet(WebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"user"}, summary="update password", description="update the password of a user", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="user", schema=@Schema(description="The username of the new user, if the username is empty your own password will be changed", type=SchemaType.STRING, minLength=3, required=false)), @SchemaProperty(name="pass", schema=@Schema(description="The password of the new user", type=SchemaType.STRING, minLength=6, required=true))}, examples={@ExampleObject(name="Set own password to 'asdasdasd'", value="{\"pass\":\"asdasdasd\"}"), @ExampleObject(name="Set password of user 'testUser3' to 'ksajfbaf'", value="{\"user\":\"testUser3\",\"pass\":\"ksajfbaf\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="OK - password was changed"), @ApiResponse(responseCode=@ResponseCode(statusCode=403), ref="#/components/responses/NoAccessError"), @ApiResponse(responseCode=@ResponseCode(statusCode=404), description="The user was not found"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), ref="#/components/responses/MissingValuesError"), @ApiResponse(responseCode=@ResponseCode(statusCode=401), ref="#/components/responses/NoAuthError")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException {
        IUser u = null;
        try {
            String user = request.getString(FIELD_USER);
            u = this.controller.getUser(user);
        }
        catch (ParameterNotFoundException ex) {
            u = request.getKosmoSUser();
        }
        String pass = request.getString(FIELD_PASS);
        if (u != null) {
            if (this.isMeOrAmAdmin(request, u)) {
                String salt = StringFunctions.generateRandomKey();
                String hash = this.controller.getPasswordHash(pass, salt);
                this.controller.setUserPassword(u, salt, hash);
                response.setStatus(204);
                return;
            }
            response.setStatus(403);
            return;
        }
        response.setStatus(404);
    }
}

