/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform;

import de.kosmos_lab.platform.KosmosPluginManager;
import de.kosmos_lab.platform.data.Config;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.Event;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.LoggingRequest;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.data.StateUpdates;
import de.kosmos_lab.platform.exceptions.CameraNotFoundException;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.GroupNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessException;
import de.kosmos_lab.platform.exceptions.NoAccessToRecording;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.exceptions.ScopeAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.gesture.GestureProvider;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.persistence.IPersistence;
import de.kosmos_lab.platform.plugins.camera.ICamera;
import de.kosmos_lab.platform.rules.RulesService;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.platform.smarthome.EventInterface;
import de.kosmos_lab.platform.smarthome.SmartHomeInterface;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import de.kosmos_lab.web.server.JWT;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;

public interface IController {
    public void addCommandInterface(@Nonnull CommandInterface var1);

    public void cacheDevice(@Nonnull Device var1);

    public void setDeviceLocation(@Nonnull String var1, @Nonnull Device.Location var2);

    public void cacheGroup(@Nonnull Group var1);

    public void cacheSchema(@Nonnull DataSchema var1);

    public void cacheScope(@Nonnull Scope var1);

    public void cacheUser(@Nonnull IUser var1);

    public boolean currentlyInTesting();

    public boolean shouldDeviceBeLogged(@Nonnull Device var1);

    public void addDevice(@Nonnull CommandInterface var1, @Nonnull Device var2, boolean var3);

    public Scope addScope(@Nonnull String var1, @Nonnull IUser var2) throws ScopeAlreadyExistsException;

    public void addScopeGroup(@Nonnull Scope var1, @Nonnull Group var2);

    public void addScopeAdminGroup(@Nonnull Scope var1, @Nonnull Group var2);

    public void addScopeUser(@Nonnull Scope var1, @Nonnull IUser var2);

    public void addScopeAdmin(@Nonnull Scope var1, @Nonnull IUser var2);

    public void addSmartHome(@Nonnull SmartHomeInterface var1);

    public void deleteDevice(@Nonnull CommandInterface var1, @Nonnull Device var2);

    public DataSchema findSchema(@Nonnull String var1, @Nonnull String var2) throws SchemaNotFoundException;

    public Collection<Device> getAllDevices();

    @Nonnull
    public Device getDevice(@Nonnull String var1) throws DeviceNotFoundException;

    @Nonnull
    public Device getDevice(@Nonnull String var1, @Nonnull IUser var2) throws DeviceNotFoundException, NoAccessToScope;

    @Nonnull
    public Device getDevice(@Nonnull String var1, @Nonnull IUser var2, @Nonnull Scope.ScopeType var3) throws DeviceNotFoundException, NoAccessToScope;

    @Nonnull
    public DataSchema getFallBackSchema();

    public void setDelScope(@Nonnull Device var1, @Nonnull Scope var2);

    public JWT getJwt();

    public String hashSaltPepper(@Nonnull String var1, @Nonnull String var2);

    public Device parseHASet(@Nonnull CommandInterface var1, @Nonnull String var2, @Nonnull JSONObject var3, @Nonnull CommandSourceName var4, @Nonnull IUser var5) throws DeviceNotFoundException, ValidationException, NoAccessToScope;

    public Device parseSet(@Nonnull CommandInterface var1, @Nonnull String var2, @Nonnull JSONObject var3, @Nonnull CommandSourceName var4, @Nonnull IUser var5) throws DeviceNotFoundException, ValidationException, NoAccessToScope;

    public Device parseSet(@Nonnull CommandInterface var1, @Nonnull Device var2, @Nonnull JSONObject var3, @Nonnull CommandSourceName var4, @Nonnull IUser var5) throws DeviceNotFoundException, ValidationException, NoAccessToScope;

    public void updateFromSource(@Nonnull CommandInterface var1, @Nonnull CommandSourceName var2, @Nonnull String var3, @Nonnull String var4, @Nonnull Object var5) throws ValidationException, DeviceNotFoundException;

    public void setName(@Nonnull Device var1, @Nonnull String var2);

    public Device.Location setLocation(@Nonnull IUser var1, @Nonnull JSONObject var2, @Nonnull CommandSourceName var3) throws DeviceNotFoundException, NoAccessToScope, ParameterNotFoundException;

    public DataSchema getSchema(@Nonnull String var1) throws SchemaNotFoundException;

    public void setReadScope(@Nonnull Device var1, @Nonnull Scope var2);

    public String hashPepper(@Nonnull String var1);

    public Group addGroup(@Nonnull String var1, @Nonnull IUser var2) throws GroupAlreadyExistsException;

    public void stop();

    public void addGroupAdmin(@Nonnull Group var1, @Nonnull IUser var2);

    public void addGroupUser(@Nonnull Group var1, @Nonnull IUser var2);

    public void setWriteScope(@Nonnull Device var1, @Nonnull Scope var2);

    public void setUserPassword(@Nonnull IUser var1, @Nonnull String var2, @Nonnull String var3);

    public CommandSourceName getSource(@Nonnull String var1);

    public IUser getUser(@Nonnull String var1);

    public IPersistence getPersistence();

    public IUser getUserCreateIfUnavailable(@Nonnull String var1);

    public Scope getScope(int var1, Constants.CacheMode var2) throws NotFoundInPersistenceException;

    public IUser getUser(int var1) throws UserNotFoundException;

    public void parseAddDevice(@Nonnull CommandInterface var1, @Nonnull JSONObject var2, @Nonnull CommandSourceName var3, @Nonnull IUser var4) throws ValidationException, DeviceAlreadyExistsException, ParameterNotFoundException, SchemaNotFoundException;

    public void parseAddDevice(@Nonnull CommandInterface var1, @Nonnull JSONObject var2, @Nonnull CommandSourceName var3, @Nonnull IUser var4, boolean var5) throws ValidationException, DeviceAlreadyExistsException, ParameterNotFoundException, SchemaNotFoundException;

    public void publishUpdate(@CheckForNull CommandInterface var1, @Nonnull Device var2, @CheckForNull String var3, @Nonnull CommandSourceName var4);

    public HashMap<Device, StateUpdates> getUpdates(@Nonnull Collection<String> var1, long var2);

    @CheckForNull
    public IUser tryLogin(@CheckForNull String var1, @CheckForNull String var2) throws LoginFailedException;

    public void updateFromSource(@Nonnull CommandInterface var1, @Nonnull CommandSourceName var2, @Nonnull Device var3, @Nonnull String var4, Object var5);

    public void updateLastUpdate(@Nonnull Device var1);

    @Nonnull
    public Scope getScope(@Nonnull String var1, Constants.CacheMode var2) throws NotFoundInPersistenceException;

    public RulesService getRulesService();

    public String getPasswordHash(String var1, String var2);

    public List<LogEntry> getLogs(@Nonnull Calendar var1, @Nonnull Calendar var2, @Nonnull Set<String> var3);

    public List<LogEntry> getLogs(@Nonnull Calendar var1, @Nonnull Calendar var2, @Nonnull String[] var3);

    @CheckForNull
    public Device.Location getLocation(@Nonnull IUser var1, @Nonnull String var2) throws DeviceNotFoundException, NoAccessToScope;

    @Nonnull
    public Group getGroup(@Nonnull String var1, Constants.CacheMode var2) throws GroupNotFoundException;

    @Nonnull
    public Group getGroup(int var1, Constants.CacheMode var2) throws GroupNotFoundException;

    public GestureProvider getGestureProvider();

    public Config getConfig();

    public KosmoSWebServer getWebServer();

    public Collection<Scope> getAllScopesWithUser(@Nonnull IUser var1);

    public Collection<Scope> getAllScopesWithAdmin(@Nonnull IUser var1);

    public Collection<DataSchema> getAllSchemas();

    public Collection<Group> getAllGroupsWithUser(@Nonnull IUser var1);

    public Collection<Group> getAllGroupsWithAdmin(@Nonnull IUser var1);

    public void deleteUser(@Nonnull IUser var1);

    public void deleteScope(@Nonnull Scope var1);

    public void deleteSchema(@Nonnull DataSchema var1);

    public void deleteDevice(@Nonnull CommandInterface var1, @Nonnull Device var2, @Nonnull String var3);

    public void deleteDevice(@Nonnull CommandInterface var1, @Nonnull Device var2, @Nonnull CommandSourceName var3);

    public boolean delScopeUser(@Nonnull Scope var1, @Nonnull IUser var2);

    public boolean delScopeAdmin(@Nonnull Scope var1, @Nonnull IUser var2);

    public boolean delGroupUser(@Nonnull Group var1, IUser var2);

    public void delGroup(@Nonnull Group var1);

    public void createSubs(@Nonnull String var1, @Nonnull String var2, @Nonnull Calendar var3, @Nonnull Calendar var4, @Nonnull List<LoggingRequest> var5, long var6);

    public boolean delGroupAdmin(@Nonnull Group var1, @Nonnull IUser var2);

    public void addUser(@Nonnull IUser var1);

    public void addSchema(@Nonnull DataSchema var1);

    public Collection<String> getMatchingUUID(@Nonnull String var1);

    public String getFileString(String var1);

    public File getFile(String var1);

    public KosmosPluginManager getPluginManager();

    @Nonnull
    public Collection<ICamera> getAllCameras();

    @Nonnull
    public ICamera getCamera(@Nonnull String var1) throws CameraNotFoundException;

    public void startRecording(@Nonnull ICamera var1, @Nonnull IUser var2);

    public void stopRecording(@Nonnull ICamera var1, @Nonnull IUser var2) throws NoAccessException;

    @Nonnull
    public Collection<File> listRecordings(@Nonnull ICamera var1, @Nonnull IUser var2);

    public byte[] getRecording(@Nonnull IUser var1, @Nonnull String var2) throws NoAccessToRecording;

    public void addDeviceText(Device var1, String var2, String var3);

    public void addEventInterface(EventInterface var1);

    public void fireEvent(Event var1, EventInterface var2);
}

