/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.smarthome.ha;

import de.kosmos_lab.platform.smarthome.ha.HomeAssistantEventConsumer;
import de.kosmos_lab.platform.smarthome.ha.HomeAssistantHTTPClient;
import de.kosmos_lab.utils.JSONChecker;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeAssistantClient
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"HomeAssistantClient");
    private final HomeAssistantHTTPClient haclient;
    public CountDownLatch initLatch;
    protected boolean stopped = false;
    int lastId = 1;
    private Session session;
    private boolean authed = false;
    private final JSONObject vars = new JSONObject();
    private final HashMap<Integer, HomeAssistantEventConsumer> consumers = new HashMap();

    public HomeAssistantClient(HomeAssistantHTTPClient haclient) {
        this.haclient = haclient;
        this.initLatch = new CountDownLatch(1);
    }

    public void addConsumer(int id, HomeAssistantEventConsumer consumer) {
        this.consumers.put(id, consumer);
    }

    public Object getVar(String name) {
        return this.vars.get(name);
    }

    public JSONObject getVars() {
        return this.vars;
    }

    public boolean isAuthed() {
        return this.authed;
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        logger.info("HA onClose");
    }

    public void onMessageReceived(String message) {
        this.onMessageReceived(new JSONObject(message));
    }

    public void onMessageReceived(JSONObject json) {
        logger.info("wsreceived: {}", (Object)json.toString());
        try {
            Integer id;
            HomeAssistantEventConsumer consumer;
            if (json.has("id") && (consumer = this.consumers.get(id = Integer.valueOf(json.getInt("id")))) != null) {
                logger.info("found consumer");
                consumer.parse(this, json);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        try {
            logger.info("HAClient onOpen");
            this.session = session;
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    logger.trace("HAClient onMessage {}", (Object)message);
                    JSONObject json = new JSONObject(message);
                    if (json.has("type")) {
                        String type = json.getString("type");
                        if (type.equals("auth_required")) {
                            HomeAssistantClient.this.authed = false;
                            try {
                                HomeAssistantClient.this.send("{\"type\": \"auth\", \"access_token\": \"" + HomeAssistantClient.this.haclient.getToken() + "\"}");
                                return;
                            }
                            catch (IOException e) {
                                logger.error("Exception!", (Throwable)e);
                            }
                        } else if (type.equals("auth_ok")) {
                            HomeAssistantClient.this.authed = true;
                        }
                    }
                    if (json.has("id")) {
                        HomeAssistantClient.this.onMessageReceived(json);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Exception!", (Throwable)e);
        }
    }

    public void send(String text) throws IOException {
        this.session.getBasicRemote().sendText(text);
    }

    public void sendCommand(JSONObject command, HomeAssistantEventConsumer consumer) {
        if (command.has("id")) {
            try {
                int id = command.getInt("id");
                if (id > this.lastId) {
                    this.lastId = id;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!command.has("id")) {
            command.put("id", ++this.lastId);
        }
        this.addConsumer(command.getInt("id"), consumer);
        try {
            logger.info("wssent: {}", (Object)command);
            this.send(command.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean waitForValue(String key, Object expected, long waittime) {
        long delta;
        long started = System.currentTimeMillis();
        do {
            try {
                Object v = this.vars.get(key);
                if (v != null) {
                    if (JSONChecker.equals((Object)v, (Object)expected)) {
                        logger.info("FOUND MATCH FOR {} - it seems to be", (Object)key, expected);
                        return true;
                    }
                    logger.info("key {} is but should be {} ", new Object[]{key, v, expected});
                } else {
                    logger.info("key {} does not exist!", (Object)key);
                }
            }
            catch (Exception v) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while ((delta = System.currentTimeMillis() - started) <= waittime);
        logger.info("GAVE UP FOR {}", (Object)key);
        logger.info("all vars: {}", (Object)this.vars);
        return false;
    }

    public void setVar(String name, Object value) {
        logger.info("setting {} to {}", (Object)name, value);
        this.vars.put(name, value);
    }

    public void stop() {
        this.stopped = true;
        try {
            this.session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

