/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.camera;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.plugins.camera.ICamera;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ApiResponseDescription;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiEndpoint(path="/camera/list", userLevel=1)
@ApiResponseDescription(name="CameraNotFoundError", description="The camera was not found")
@ObjectSchema(componentName="camera", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the camera", type=SchemaType.STRING, required=true)), @SchemaProperty(name="recording", schema=@Schema(description="Is the camera currently recording?", type=SchemaType.BOOLEAN, required=true)), @SchemaProperty(name="recordings", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of camera recordings", ref="#/components/schemas/cameraRecording", required=false)))})
public class CameraListServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_DETAILS = "details";

    public CameraListServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"camera"}, summary="List available cameras", description="List all known cameras.", parameters={@Parameter(description="Include more details in the response. If true the response will also contain the currently available recordings of the camera (the recordings you made).", in=ParameterIn.QUERY, name="details", schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false"), required=false)}, responses={@ApiResponse(description="List of cameras", responseCode=@ResponseCode(statusCode=200), content={@Content(mediaType="application/json", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(ref="#/components/schemas/camera")), examples={@ExampleObject(name="example without details", value="[{\"name\":\"camera1\",\"recording\":true},{\"name\":\"camera2\",\"recording\":false}]"), @ExampleObject(name="example with details", value="[{\"name\":\"camera1\",\"recording\":true,recordings:[{\"size\": 158373240, \"name\": \"camera1_2022-03-22_17-51-32.mp4\"},{\"size\": 70586289, \"name\": \"camera1_2022-03-22_17-48-51.mp4\"}]},{\"name\":\"camera2\",\"recording\":false,\"recordings\":[]}]")})})})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, UnauthorizedException {
        boolean details = request.getBoolean(FIELD_DETAILS, false);
        JSONArray arr = new JSONArray();
        for (ICamera camera : this.controller.getAllCameras()) {
            JSONObject json = new JSONObject().put("name", (Object)camera.getName()).put("recording", camera.isRecording());
            if (details) {
                JSONArray recordings = new JSONArray();
                for (File f : this.controller.listRecordings(camera, request.getKosmoSUser())) {
                    recordings.put((Object)new JSONObject().put("name", (Object)f.getName()).put("size", f.length()));
                }
                json.put("recordings", (Object)recordings);
            }
            arr.put((Object)json);
        }
        CameraListServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONArray)arr);
    }
}

