/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.group;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.exceptions.NoAccessToGroup;
import de.kosmos_lab.platform.exceptions.NotFoundException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/group/adduser", userLevel=1)
public class GroupAddUserServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_GROUP = "group";
    public static final String FIELD_USER = "user";

    public GroupAddUserServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"group"}, summary="add user", description="Add an user with user access to a group.", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="group", schema=@Schema(description="The group to which to add the user to", type=SchemaType.STRING, required=true)), @SchemaProperty(name="user", schema=@Schema(description="The username of the user to add to the group", type=SchemaType.STRING, required=true))}, examples={@ExampleObject(name="add user 'testUser' to group 'testGroup'", value="{\"group\":\"testGroup\",\"user\":\"testUser\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The user was added successfully")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, NoAccessToGroup, NotFoundException, ParameterNotFoundException, UnauthorizedException {
        String sname = request.getString(FIELD_GROUP);
        String uname = request.getString(FIELD_USER);
        Group group = this.controller.getGroup(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
        if (group.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
            IUser u = this.controller.getUser(uname);
            if (u != null) {
                logger.info("adding user {} to group {}", (Object)group.getID(), (Object)u.getUUID().getLeastSignificantBits());
                this.controller.addGroupUser(group, u);
                response.setStatus(204);
                return;
            }
            throw new UserNotFoundException(uname);
        }
        throw new NoAccessToGroup(group);
    }
}

