/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.schreibtrainer;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.TimedList;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSServlet;
import de.kosmos_lab.platform.web.servlets.schreibtrainer.SchreibtrainerConstants;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

@ApiEndpoint(path="/schreibtrainer/word", userLevel=-1)
public class SchreibtrainerWordServlet
extends KosmoSServlet {
    public static final String FIELD_TEXT = "text";

    public SchreibtrainerWordServlet(KosmoSWebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    @Operation(tags={"schreibtrainer"}, summary="word", description="Add a word to a pen", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="uuid", schema=@Schema(description="The UUID of the pen to add the text to", type=SchemaType.STRING, required=true)), @SchemaProperty(name="text", schema=@Schema(description="The text you want to add", type=SchemaType.STRING, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The word was added successfully")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ParameterNotFoundException {
        String uuid = request.getParameter("uuid");
        JSONObject o = request.getBodyAsJSONObject();
        if (o == null) {
            throw new ParameterNotFoundException("body");
        }
        if (uuid == null) {
            uuid = o.optString("uuid", null);
        }
        if (uuid == null) {
            throw new ParameterNotFoundException("uuid");
        }
        String newword = o.getString(FIELD_TEXT);
        logger.warn("got new word {} on {}: ", (Object)uuid, (Object)newword);
        try {
            Device device = SchreibtrainerConstants.getDevice(this.controller, this.server, uuid);
            TimedList wl = SchreibtrainerConstants.getWordList(this.controller, this.server, device);
            wl.addEntry(newword);
            device.updateFromJSON(this.server, new JSONObject().put(FIELD_TEXT, (Object)newword).put("wordList", (Object)wl.toJSONArray()), this.controller.getSource("stabilo"));
            SchreibtrainerWordServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)o);
            return;
        }
        catch (SchemaNotFoundException e) {
            e.printStackTrace();
        }
        catch (DeviceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(422);
            return;
        }
        response.setStatus(500);
    }
}

