/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.scope;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.ScopeNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import jakarta.servlet.http.HttpServletResponse;

@ApiEndpoint(path="/scope/deladmin", userLevel=1)
public class ScopeDelAdminServlet
extends KosmoSAuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_SCOPE = "scope";

    public ScopeDelAdminServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="delete user", description="delete a users access from a scope", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="scope", schema=@Schema(description="The scope from which to remove the user", type=SchemaType.STRING, required=true)), @SchemaProperty(name="user", schema=@Schema(description="The username of the user to delete from the scope", type=SchemaType.STRING, required=true))}, examples={@ExampleObject(name="add user 'testUser' to scope 'testScope'", value="{\"scope\":\"testScope\",\"user\":\"testUser\"}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The user was removed from the group successfully.")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws NoAccessToScope, ScopeNotFoundException, ParameterNotFoundException, UnauthorizedException {
        String sname = request.getString(FIELD_SCOPE);
        String uname = request.getString(FIELD_USER);
        try {
            IUser u;
            Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
            if ((scope.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) && (u = this.controller.getUser(uname)) != null) {
                this.controller.delScopeAdmin(scope, u);
                response.setStatus(204);
                return;
            }
            throw new NoAccessToScope(scope);
        }
        catch (NotFoundInPersistenceException ex) {
            throw new ScopeNotFoundException(sname);
        }
    }
}

