/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KosmoSHTTPClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"KosmoSClient");
    private final String base;
    private final String user;
    private String pass;
    private String token = null;

    public KosmoSHTTPClient(@Nonnull String baseurl, @Nonnull String user, @Nonnull String pass) throws Exception {
        this.base = baseurl;
        this.user = user;
        this.pass = pass;
        this.start();
    }

    public KosmoSHTTPClient(@Nonnull String baseurl, @Nonnull String token) throws Exception {
        this.base = baseurl;
        this.token = token;
        this.user = null;
        this.pass = null;
        this.start();
    }

    @CheckForNull
    public Request createAuthedDeleteRequest(@Nonnull String url, @CheckForNull JSONObject body) {
        Request request = this.createAuthedRequest(url, HttpMethod.DELETE);
        if (request != null && body != null) {
            request.body((Request.Content)new StringRequestContent("application/json", body.toString()));
        }
        return request;
    }

    @CheckForNull
    public Request createAuthedPostRequest(@Nonnull String url, @CheckForNull JSONObject body) {
        Request request = this.createAuthedRequest(url, HttpMethod.POST);
        if (request != null && body != null) {
            request.body((Request.Content)new StringRequestContent("application/json", body.toString()));
        }
        return request;
    }

    @CheckForNull
    public Request createAuthedRequest(@Nonnull String url, @Nonnull HttpMethod method) {
        if (this.token == null && !this.refreshToken()) {
            return null;
        }
        Request request = this.createRequest(url, method);
        if (request != null) {
            request.headers(headers -> headers.put(HttpHeader.AUTHORIZATION, String.format("Bearer %s", this.token)));
        }
        return request;
    }

    @CheckForNull
    public Request createAuthedRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONObject body) {
        Request request = this.createAuthedRequest(url, method);
        if (request != null && body != null) {
            request.body((Request.Content)new StringRequestContent("application/json", body.toString()));
        }
        return request;
    }

    @CheckForNull
    public Request createAuthedRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONArray body) {
        Request request = this.createAuthedRequest(url, method);
        if (request != null && body != null) {
            request.body((Request.Content)new StringRequestContent("application/json", body.toString()));
        }
        return request;
    }

    @CheckForNull
    public Request createAuthedRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull String body) {
        Request request = this.createAuthedRequest(url, method);
        if (request != null && body != null) {
            request.body((Request.Content)new StringRequestContent("application/text", body));
        }
        return request;
    }

    @CheckForNull
    private Request createRequest(@Nonnull String url, @Nonnull HttpMethod method) {
        if (!((String)url).startsWith("http")) {
            url = this.base + (String)url;
        }
        logger.info("{}: creating {} request for to {}", new Object[]{this.getUserName(), method.name(), url});
        Request request = this.newRequest((String)url);
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    @CheckForNull
    public JSONArray fetchJSONArray(@Nonnull String url, @Nonnull HttpMethod method) {
        ContentResponse response;
        Request request = this.createAuthedRequest(url, method);
        if (request != null && (response = this.getResponse(request)) != null) {
            return new JSONArray(response.getContentAsString());
        }
        return null;
    }

    @CheckForNull
    public JSONObject fetchJSONObject(@Nonnull String url, @Nonnull HttpMethod method, String[][] params) {
        Request request = this.createAuthedRequest(url, method);
        if (request != null) {
            ContentResponse response;
            if (params != null) {
                for (String[] p : params) {
                    if (p.length != 2) continue;
                    request.param(p[0], p[1]);
                }
            }
            if ((response = this.getResponse(request)) != null) {
                return new JSONObject(response.getContentAsString());
            }
        }
        return null;
    }

    @CheckForNull
    public JSONArray getJSONArray(@Nonnull String url) {
        return this.fetchJSONArray(url, HttpMethod.GET);
    }

    @CheckForNull
    public JSONObject getJSONObject(String url) {
        return this.fetchJSONObject(url, HttpMethod.GET, null);
    }

    @CheckForNull
    public JSONObject getJSONObject(String url, String[][] params) {
        return this.fetchJSONObject(url, HttpMethod.GET, params);
    }

    @CheckForNull
    public String getPassword() {
        return this.pass;
    }

    public void setPassword(@Nonnull String pass) {
        this.pass = pass;
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull String body) {
        Request request = this.createAuthedRequest(url, method, body);
        if (request != null) {
            return this.getResponse(request);
        }
        return null;
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONObject body) {
        Request request = this.createAuthedRequest(url, method, body);
        if (request != null) {
            return this.getResponse(request);
        }
        return null;
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONArray body) {
        Request request = this.createAuthedRequest(url, method, body);
        if (request != null) {
            return this.getResponse(request);
        }
        return null;
    }

    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method) {
        return this.getResponse(url, method, new String[][]{new String[0]});
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, String[][] params) {
        Request request = this.createAuthedRequest(url, method);
        if (request != null) {
            if (params != null) {
                for (String[] p : params) {
                    if (p.length != 2) continue;
                    request.param(p[0], p[1]);
                }
            }
            return this.getResponse(request);
        }
        return null;
    }

    @CheckForNull
    public ContentResponse getResponse(@CheckForNull Request request) {
        if (request == null) {
            return null;
        }
        ContentResponse response = null;
        try {
            response = request.send();
            if (response.getStatus() == 401) {
                this.refreshToken();
                request.header("Authorization", "Bearer " + this.token);
                response = request.send();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("could not get Response for Request", (Throwable)e);
        }
        return response;
    }

    @CheckForNull
    public String getUserName() {
        return this.user;
    }

    @CheckForNull
    public String login() {
        Request request = this.createRequest("/user/login", HttpMethod.POST);
        if (request != null) {
            try {
                request.param("user", this.user);
                request.param("pass", this.pass);
                ContentResponse response = request.send();
                logger.info("login status: {}", (Object)response.getStatus());
                if (response.getStatus() == 200) {
                    return response.getContentAsString();
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error("could not get Response for Request", (Throwable)e);
            }
        }
        return null;
    }

    @CheckForNull
    public JSONObject postJSONObject(@Nonnull String url, @CheckForNull JSONObject body) {
        ContentResponse response = this.getResponse(url, HttpMethod.POST, body);
        if (response != null) {
            return new JSONObject(response.getContentAsString());
        }
        return null;
    }

    @CheckForNull
    public ContentResponse postJSONObject2(@Nonnull String url, @CheckForNull JSONObject body) {
        return this.getResponse(url, HttpMethod.POST, body);
    }

    public boolean refreshToken() {
        if (this.user != null && this.pass != null) {
            String t = this.login();
            if (t != null) {
                this.token = t;
                return true;
            }
        } else {
            this.token = "";
            return true;
        }
        return false;
    }
}

