/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.persistence;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.DeviceText;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.KosmoSUser;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.ScopeAlreadyExistsException;
import de.kosmos_lab.platform.persistence.Models;
import de.kosmos_lab.platform.persistence.SQLPersistence;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.json.JSONObject;

public class KosmoSPersistence
extends SQLPersistence
implements CommandInterface {
    private static KosmoSPersistence instance;
    HikariDataSource dsRead;
    HikariDataSource dsWrite;

    @SuppressFBWarnings(value={"DM_EXIT", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public KosmoSPersistence(@Nonnull JSONObject conf, @Nonnull IController server, boolean fastinit) {
        this.numConnections = BigInteger.ZERO;
        this.connections = new LinkedList();
        this.server = server;
        this.url = conf.getString("url");
        logger.info("Using db file: {}", (Object)this.url);
        instance = this;
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.url);
        File db = server.getFile("db/");
        if (!db.exists() && !db.mkdirs()) {
            logger.warn("could not create database folder \"{}\" - exiting", (Object)db);
            System.exit(1);
        }
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("characterEncoding", (Object)"UTF-8");
        config.addDataSourceProperty("useUnicode", (Object)"true");
        this.dsRead = new HikariDataSource(config);
        this.dsRead.setMaximumPoolSize(100);
        this.dsWrite = new HikariDataSource(config);
        this.dsWrite.setMaximumPoolSize(1);
        server.addCommandInterface(this);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static KosmoSPersistence getInstance() {
        return instance;
    }

    @Override
    public void addDevice(@Nonnull Device device) {
        this.doAdd("insert into `devices` (`uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner`) values (?,?,?,?,?,?)", new Object[]{device.getUniqueID(), device.getName(), device.getSchema().getId(), device.getSource().getSourceName(), device.getLastUpdated().getTime(), device.getOwner().getUUID().getLeastSignificantBits()});
        this.server.cacheDevice(device);
    }

    @Override
    @Nonnull
    public Group addGroup(@Nonnull String name, @Nonnull IUser user) throws GroupAlreadyExistsException {
        int id = this.doAddI("insert into `groups` (`name`) values (?)", new Object[]{name});
        if (id > 0) {
            Group group = new Group(id, name);
            this.server.cacheGroup(group);
            this.addGroupAdmin(group, user);
            return group;
        }
        throw new GroupAlreadyExistsException(name);
    }

    @Override
    public void addGroupAdmin(@Nonnull Group group, @Nonnull IUser user) {
        group.addAdmin(user);
        try {
            this.doAdd("insert into `group_admins` (`user`,`group`) values (?,?)", new Object[]{user.getUUID().getLeastSignificantBits(), group.getID()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.info(KosmoSPersistence.fullPrint("insert into `group_admins` (`user`,`group`) values (?,?)", new Object[]{user.getUUID().getLeastSignificantBits(), group.getID()}));
        }
    }

    @Override
    public void addGroupUser(@Nonnull Group group, @Nonnull IUser user) {
        group.addUser(user);
        this.doAdd("insert into `group_users` (`user`,`group`) values (?,?)", new Object[]{user.getUUID().getLeastSignificantBits(), group.getID()});
    }

    @Override
    public void addSchema(@Nonnull DataSchema schema) {
        this.doAdd("insert into `schemas` (`ID`,`schema`) values (?,?)", new Object[]{schema.getSchema().getId(), schema.getRawSchema()});
        this.server.cacheSchema(schema);
    }

    @Override
    @Nonnull
    public Scope addScope(@Nonnull String name, @Nonnull IUser user) throws ScopeAlreadyExistsException {
        int id = this.doAddI("insert into `scopes` (`name`) values (?)", new Object[]{name});
        if (id > 0) {
            Scope scope = new Scope(id, name);
            this.server.cacheScope(scope);
            this.addScopeAdmin(scope, user);
            return scope;
        }
        throw new ScopeAlreadyExistsException(name);
    }

    @Override
    public void addScopeAdmin(@Nonnull Scope scope, @Nonnull IUser user) {
        scope.addAdmin(user);
        this.doAdd("insert into `scope_admins` (`user`,`scope`) values (?,?)", new Object[]{user.getUUID().getLeastSignificantBits(), scope.getID()});
    }

    @Override
    public void addScopeGroup(@Nonnull Scope scope, @Nonnull Group group) {
        scope.addUserGroup(group);
        this.doAdd("insert into `scope_group_user` (`Group`,`scope`) values (?,?)", new Object[]{group.getID(), scope.getID()});
    }

    @Override
    public void addScopeAdminGroup(@Nonnull Scope scope, @Nonnull Group group) {
        scope.addAdminGroup(group);
        this.doAdd("insert into `scope_group_admin` (`Group`,`scope`) values (?,?)", new Object[]{group.getID(), scope.getID()});
    }

    @Override
    public void addScopeUser(@Nonnull Scope scope, @Nonnull IUser user) {
        scope.addUser(user);
        this.doAdd("insert into `scope_users` (`user`,`scope`) values (?,?)", new Object[]{user.getUUID().getLeastSignificantBits(), scope.getID()});
    }

    @Override
    public void addUser(@Nonnull IUser user) {
        if (user instanceof KosmoSUser) {
            KosmoSUser kuser = (KosmoSUser)user;
            int id = this.doAddI("insert into `users` (`name`,`level`,`salt`,`hash`) values (?,?,?,?)", new Object[]{user.getName(), user.getLevel(), kuser.getSalt(), kuser.getHash()});
            if (id != 0) {
                kuser.setID(id);
            }
            this.server.cacheUser(user);
        }
    }

    @Override
    protected Connection connect(@Nonnull String query) {
        this.numConnections = this.numConnections.add(BigInteger.ONE);
        try {
            Connection c = query.toLowerCase().startsWith("select") ? this.dsRead.getConnection() : this.dsWrite.getConnection();
            if (c != null && !c.isClosed()) {
                this.connections.add(c);
                return c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.warn("no connection to SQL!");
        return null;
    }

    @Override
    protected void createTable(@Nonnull String table) {
        String fTable = String.format("`%s`", table);
        for (Class<?> c : Models.class.getDeclaredClasses()) {
            try {
                Field t = c.getDeclaredField("table");
                if (!table.equals(t) && !fTable.equals(t)) continue;
                Field f = c.getDeclaredField("create");
                this.doUpdate(String.valueOf(f.get(null)));
                return;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void delDevice(@Nonnull Device device) {
        this.doUpdate("delete from `devices`  where `uuid`=?", new Object[]{device.getUniqueID()});
    }

    @Override
    public void delGroup(@Nonnull Group group) {
        logger.info("deleting users from group: {} matches", (Object)this.doUpdate("delete from `group_users`  where `group`=?", new Object[]{group.getID()}));
        logger.info("deleting admin from group: {} matches", (Object)this.doUpdate("delete from `group_admins`  where `group`=?", new Object[]{group.getID()}));
        logger.info("deleting group: {} matches", (Object)this.doUpdate("delete from `groups`  where `name`=?", new Object[]{group.getName()}));
    }

    @Override
    public void delGroupAdmin(@Nonnull Group group, @Nonnull IUser user) {
        group.delAdmin(user);
        this.doUpdate("delete from `group_users`  where `user`=? AND `group`=?", new Object[]{user.getUUID().getLeastSignificantBits(), group.getID()});
    }

    @Override
    public void delGroupUser(@Nonnull Group group, @Nonnull IUser user) {
        group.delUser(user);
        this.doUpdate("delete from `group_users`  where `user`=? AND `group`=?", new Object[]{user.getUUID().getLeastSignificantBits(), group.getID()});
    }

    @Override
    public void delSchema(@Nonnull DataSchema schema) {
        this.doUpdate("delete from `schemas`  where `ID`=?", new Object[]{schema.getSchema().getId()});
    }

    @Override
    public void delScope(@Nonnull Scope scope) {
        logger.info("deleting scope: {}", (Object)scope.getName());
        this.doUpdate("delete from `scope_admins`  where `scope`=?", new Object[]{scope.getID()});
        this.doUpdate("delete from `scope_group_admin`  where `scope`=?", new Object[]{scope.getID()});
        this.doUpdate("delete from `scope_users`  where `scope`=?", new Object[]{scope.getID()});
        this.doUpdate("delete from `scope_group_user`  where `scope`=?", new Object[]{scope.getID()});
        this.doUpdate("delete from `scopes` where `id`=?", new Object[]{scope.getID()});
    }

    @Override
    public void delScopeAdmin(@Nonnull Scope scope, @Nonnull IUser user) {
        scope.delAdmin(user);
        this.doUpdate("delete from `scope_admins`  where `user`=? AND `scope`=?", new Object[]{user.getUUID().getLeastSignificantBits(), scope.getID()});
    }

    @Override
    public void delScopeUser(@Nonnull Scope scope, @Nonnull IUser user) {
        scope.delUser(user);
        this.doUpdate("delete from `scope_users`  where `user`=? AND `scope`=?", new Object[]{user.getUUID().getLeastSignificantBits(), scope.getID()});
    }

    @Override
    public void delUser(@Nonnull IUser user) {
        this.doUpdate("delete from `users`  where `name`=?", new Object[]{user.getName()});
    }

    @Override
    public void deviceAdded(@CheckForNull CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
        this.addDevice(device);
        this.deviceUpdate(this, device, null, device.getSource());
    }

    @Override
    public void deviceRemoved(@CheckForNull CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
        this.delDevice(device);
    }

    @Override
    public void deviceUpdate(@CheckForNull CommandInterface from, @Nonnull Device device, @CheckForNull String key, @Nonnull CommandSourceName source) {
        if (!this.server.shouldDeviceBeLogged(device)) {
            this.doUpdate("delete from `states` where `uuid`=?", new Object[]{device.getUniqueID()});
        }
        this.doAdd("insert into `states` (`uuid`,`state`,`date`,`source`) values (?,?,?,?)", new Object[]{device.getUniqueID(), device.toString(), System.currentTimeMillis(), source.getSourceName()});
    }

    @Override
    public void fillDeviceScopes(@Nonnull Device device) {
        this.doSelect("select `uuid`,`read`,`write`,`del` from `scope_devices` where `uuid`=?", new Object[]{device.getUniqueID()}, Models.SQL_Scope_Devices::parse);
    }

    @Override
    public void fillTexts(@Nonnull Device device) {
        this.doSelect("select `uuid`,`key`,`value` from `device_text` where `uuid`= ? ", new Object[]{device.getUniqueID()}, Models.SQL_Device_Text::parse);
    }

    @Override
    public void fillGroup(@Nonnull Group group) {
        this.doSelect("select `user`,`group` from `group_users` where `group`=?", new Object[]{group.getID()}, Models.SQL_Group_Users::parse);
        this.doSelect("select `user`,`group` from `group_admins` where `group`=?", new Object[]{group.getID()}, Models.SQL_Group_Admins::parse);
    }

    @Override
    public void fillScope(@Nonnull Scope scope) {
        this.doSelect("select `user`,`scope` from `scope_users` where `scope`=?", new Object[]{scope.getID()}, Models.SQL_Scope_Users::parse);
        this.doSelect("select `user`,`scope` from `scope_admins` where `scope`=?", new Object[]{scope.getID()}, Models.SQL_Scope_Admins::parse);
        this.doSelect("select `Group`,`scope` from `scope_group_user` where `scope`=?", new Object[]{scope.getID()}, Models.SQL_Scope_Group_User::parse);
        this.doSelect("select `Group`,`scope` from `scope_group_admin` where `scope`=?", new Object[]{scope.getID()}, Models.SQL_Scope_Group_Admins::parse);
    }

    @Override
    @Nonnull
    public Group getGroup(@Nonnull String name) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name` from `groups` where `name`=?", new Object[]{name}, Models.SQL_Groups::parse);
    }

    @Override
    @Nonnull
    public Group getGroup(int id) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name` from `groups` where `id`=?", new Object[]{id}, Models.SQL_Groups::parse);
    }

    @Nonnull
    private String getIn(Set<String> in) {
        if (in.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iter = in.iterator();
            sb.append("('");
            sb.append(iter.next());
            sb.append("'");
            while (iter.hasNext()) {
                sb.append(",'");
                sb.append(iter.next());
                sb.append("'");
            }
            sb.append(")");
            return sb.toString();
        }
        return "()";
    }

    @Nonnull
    private String getIn(String[] in) {
        if (in.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("('");
            sb.append(in[0]);
            sb.append("'");
            for (int i = 1; i < in.length; ++i) {
                sb.append(",'");
                sb.append(in[i]);
                sb.append("'");
            }
            sb.append(")");
            return sb.toString();
        }
        return "()";
    }

    @Override
    @Nonnull
    public JSONObject getLastState(@Nonnull String uuid) {
        try {
            return this.doSelectFirst("select `uuid`,`state`,`date`,`source` from `states` where `uuid`=? ORDER BY `date` DESC LIMIT 0,1", new Object[]{uuid}, Models.SQL_States::parse).getState();
        }
        catch (NotFoundInPersistenceException notFoundInPersistenceException) {
            return new JSONObject();
        }
    }

    @Override
    public int getNumberOfDevicesWithSchema(@Nonnull DataSchema schema) {
        try {
            return this.doSelectFirstAsInt("select count(`uuid`) from `devices` where `schema`=?", new Object[]{schema.getSchema().getId()});
        }
        catch (NotFoundInPersistenceException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    @Nonnull
    public DataSchema getSchema(@Nonnull String id) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `ID`,`schema` from `schemas` where `ID`=?", new Object[]{id}, Models.SQL_Schemas::parse);
    }

    @Override
    @Nonnull
    public Scope getScope(@Nonnull String name) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name` from `scopes` where `name`=?", new Object[]{name}, Models.SQL_Scopes::parse);
    }

    @Override
    @Nonnull
    public Scope getScope(int id) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name` from `scopes` where `id`=?", new Object[]{id}, Models.SQL_Scopes::parse);
    }

    @Override
    public String getSourceName() {
        return "Persistence";
    }

    @Override
    @Nonnull
    public List<LogEntry> getStates(long from, long to, @Nonnull String[] uuids) {
        return this.doSelect("select `uuid`,`state`,`date`,`source` from `states` where `uuid` IN ? AND `date`>=? AND `date`<=? ORDER BY `date`".replaceFirst("\\?", this.getIn(uuids)), new Object[]{from, to}, Models.SQL_States::parse);
    }

    @Override
    @Nonnull
    public List<LogEntry> getStates(long from, long to, @Nonnull Set<String> uuids) {
        return this.doSelect("select `uuid`,`state`,`date`,`source` from `states` where `uuid` IN ? AND `date`>=? AND `date`<=? ORDER BY `date`".replaceFirst("\\?", this.getIn(uuids)), new Object[]{from, to}, Models.SQL_States::parse);
    }

    @Override
    public List<LogEntry> getStates(long from, long to) {
        return this.doSelect("select `uuid`,`state`,`date`,`source` from `states` where `date`>=? AND `date`<=? ORDER BY `date`", new Object[]{from, to}, Models.SQL_States::parse);
    }

    @Override
    @Nonnull
    public IUser getUser(int id) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name`,`level`,`salt`,`hash` from `users` where `id`=?", new Object[]{id}, Models.SQL_Users::parse);
    }

    @Override
    @Nonnull
    public IUser getUser(@Nonnull String username) throws NotFoundInPersistenceException {
        return this.doSelectFirst("select `id`,`name`,`level`,`salt`,`hash` from `users` where `name`=?", new Object[]{username}, Models.SQL_Users::parse);
    }

    @Override
    public void init() {
        for (Class<?> clazz : Models.class.getDeclaredClasses()) {
            try {
                String query = (String)clazz.getField("create").get(null);
                for (String q : query.split(";")) {
                    if ((q = q.trim()).length() <= 2) continue;
                    this.doUpdate(q);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.initUsers();
        this.initGroups();
        this.initSchema();
        this.initDevices();
        this.initScopes();
        this.initLocations();
        this.initTexts();
    }

    @Override
    @Nonnull
    public Collection<Device> initDevices() {
        return this.doSelect("select `uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner` from `devices`", new Object[0], Models.SQL_Devices::parse);
    }

    @Override
    @Nonnull
    public Collection<Group> initGroups() {
        return this.doSelect("select `id`,`name` from `groups`", new Object[0], Models.SQL_Groups::parse);
    }

    @Override
    public Collection<Device.Location> initLocations() {
        return this.doSelect("select `uuid`,`x`,`y`,`z`,`w`,`d`,`h`,`roll`,`pitch`,`yaw`,`area` from `device_location`", new Object[0], Models.SQL_Device_Location::parse);
    }

    public Collection<DeviceText> initTexts() {
        return this.doSelect("select `uuid`,`key`,`value` from `device_text`", new Object[0], Models.SQL_Device_Text::parse);
    }

    @Override
    public void addDeviceText(DeviceText dt) {
        this.doAdd("insert into `device_text` (`uuid`,`key`,`value`) values (?,?,?)", new Object[]{dt.getDevice().getUniqueID(), dt.getKey(), dt.getValue()});
    }

    @Override
    public void updateDeviceText(DeviceText dt) {
        this.doAdd("update `device_text` SET `value`=? where `uuid`=? AND `key`=?", new Object[]{dt.getValue(), dt.getDevice().getUniqueID(), dt.getKey()});
    }

    @Override
    @Nonnull
    public Collection<DataSchema> initSchema() {
        return this.doSelect("select `ID`,`schema` from `schemas`", new Object[0], Models.SQL_Schemas::parse);
    }

    @Override
    @Nonnull
    public Collection<Scope> initScopes() {
        List<Scope> list = this.doSelect("select `id`,`name` from `scopes`", new Object[0], Models.SQL_Scopes::parse);
        this.doSelect("select `uuid`,`read`,`write`,`del` from `scope_devices`", new Object[0], Models.SQL_Scope_Devices::parse);
        return list;
    }

    @Override
    @Nonnull
    public List<KosmoSUser> initUsers() {
        return this.doSelect("select `id`,`name`,`level`,`salt`,`hash` from `users`", new Object[0], Models.SQL_Users::parse);
    }

    @Override
    public void setDelScope(@Nonnull Device device, @Nonnull Scope scope) {
        this.doUpdate("update `scope_devices` set `del`=? where `uuid`=?", new Object[]{scope.getID(), device.getUniqueID()});
    }

    @Override
    public void setName(@Nonnull Device device, @Nonnull String name) {
        device.setName(name);
        this.doUpdate("update `devices` set `name`=? where `uuid`=?", new Object[]{device.getName(), device.getUniqueID()});
    }

    @Override
    public void setPassword(@Nonnull IUser user, @Nonnull String salt, @Nonnull String hash) {
        this.doUpdate("update `users` set `hash`=? where `name`=?", new Object[]{hash, user.getName()});
        this.doUpdate("update `users` set `salt`=? where `name`=?", new Object[]{salt, user.getName()});
        if (user instanceof KosmoSUser) {
            ((KosmoSUser)user).setPassword(salt, hash);
        }
    }

    @Override
    public void setReadScope(@Nonnull Device device, @Nonnull Scope scope) {
        this.doUpdate("update `scope_devices` set `read`=? where `uuid`=?", new Object[]{scope.getID(), device.getUniqueID()});
    }

    @Override
    public void setWriteScope(@Nonnull Device device, @Nonnull Scope scope) {
        this.doUpdate("update `scope_devices` set `write`=? where `uuid`=?", new Object[]{scope.getID(), device.getUniqueID()});
    }

    @Override
    public void stop() {
        this.dsRead.close();
        this.dsWrite.close();
    }

    public String toString() {
        return "Persistence";
    }

    @Override
    public void updateLastUpdate(@Nonnull Device device) {
        this.doUpdate("update `devices` set `lastUpdate`=? where `uuid`=?", new Object[]{device.getLastUpdated().getTime(), device.getUniqueID()});
    }

    @Override
    public void updateLocation(@Nonnull Device device) {
        Device.Location loc = device.getLocation();
        if (loc != null) {
            this.doUpdate("REPLACE into `device_location` (`uuid`,`x`,`y`,`z`,`w`,`d`,`h`,`roll`,`pitch`,`yaw`,`area`) values (?,?,?,?,?,?,?,?,?,?,?)", new Object[]{device.getUniqueID(), loc.getX(), loc.getY(), loc.getZ(), loc.getW(), loc.getD(), loc.getH(), loc.getRoll(), loc.getPitch(), loc.getYaw(), loc.getArea()});
        }
    }
}

