/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.Event;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.rules.RulesService;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.platform.smarthome.EventInterface;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.servers.AsyncServer;
import de.kosmos_lab.web.annotations.servers.AsyncServers;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.doc.openapi.Channel;
import de.kosmos_lab.web.doc.openapi.Message;
import de.kosmos_lab.web.doc.openapi.WebSocketEndpoint;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.server.JWT;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.WebSocketService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(name="user_token", type=SchemaType.STRING, allowableValues={"user/token:{token}"})
@AsyncServers(value={@AsyncServer(protocol="wss", name="wss", url="wss://${host}", description="Websocket base.\n\n<b><em>INFO</em></b>:All messages tagged with \"authRequired\" in the binding need to have the client authenticate, this can be done either via <a href=\"#operation-subscribe-user/login\">user/login</a> or <a href=\"#operation-subscribe-user/token\">user/token</a>"), @AsyncServer(protocol="mqtt", name="mqtt", url="mqtt://${host}")})
@WebSocketEndpoint(path="/ws", enableMQTT=true, enableWS=true, channels={@Channel(tags={@Tag(name="KosmoS")}, path="user/token", subscribeMessages={@Message(name="user/token", payloadSchema={@Schema(ref="#/components/schemas/user_token")})}), @Channel(tags={@Tag(name="KosmoS")}, path="user/login", subscribeMessages={@Message(name="user/login", payload=@ObjectSchema(properties={@SchemaProperty(name="user", schema=@Schema(type=SchemaType.STRING, description="the username to login in with")), @SchemaProperty(name="pass", schema=@Schema(type=SchemaType.STRING, description="the password to login in with"))}, examples={@ExampleObject(name="login for karl", value="{\"user\":\"karl\",\"pass\",\"verysecret\"}")}))}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="locations", needsMessage=false, subscribeMessages={@Message(description="This messages signals to the server, that we are interested in getting all device locations. The server will return all locations via <a href=\"#operation-publish-device/{uuid}/location\">device/{uuid}/location</a>.", payloadSchema={@Schema})}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/set", subscribeMessages={@Message(name="device_set", payloadSchema={@Schema(type=SchemaType.OBJECT, description="the value(s) to set", examples={@ExampleObject(name="change temperature for heating", value="{\"heatingTemperatureSetting\":20.5}"), @ExampleObject(name="set rgb color", value="{\"color\":{\"r\":255,\"g\":0,\"b\":255}}"), @ExampleObject(name="turn off ", value="{\"on\":false}"), @ExampleObject(name="turn off HomeAssistant device", value="{\"state\":\"OFF\"}")})})}, parameters={@Parameter(description="the uuid of the device you want to control", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/event", subscribeMessages={@Message(name="device_event", payloadSchema={@Schema(ref="/doc/openapi.yaml#/components/schemas/event")})}, parameters={@Parameter(description="The UUID of the device this event belongs to, events will only be visible for users with read access to the device", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="/event", subscribeMessages={@Message(name="event", payloadSchema={@Schema(ref="/doc/openapi.yaml#/components/schemas/event")})}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/location", subscribeMessages={@Message(name="device/setLocation", payloadSchema={@Schema(ref="/doc/openapi.yaml#/components/schemas/deviceLocation")})}, parameters={@Parameter(description="the uuid of the device you want to control", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/config", subscribeMessages={@Message(name="device/add", payload=@ObjectSchema(properties={@SchemaProperty(name="schema", schema=@Schema(description="The $id/url of the schema to use. If its a schema not already in the system the $id MUST be a reachable Url describing the schema.", type=SchemaType.STRING, required=true)), @SchemaProperty(name="name", schema=@Schema(description="The name to use for the new device, if no name is set uuid will be used. Does not need to be unique.", type=SchemaType.STRING, minLength=3, required=false)), @SchemaProperty(name="state", schema=@Schema(description="The starting state of the device, needs to contain all required values if the schema has any and needs to be valid against the schema.", type=SchemaType.OBJECT, defaultValue="{}", required=false)), @SchemaProperty(name="scopes", schema=@Schema(description="The name of the scope to use for the new device.", ref="/doc/openapi.yaml#/components/schemas/deviceScopes"))}, examples={@ExampleObject(name="/device/multi2/config", value="{\"name\":\"multi2\",\"schema\":\"https://kosmos-lab.de/schema/MultiSensor.json\",\"state\":{\"currentEnvironmentTemperature\":17,\"humidityLevel\":10}}"), @ExampleObject(name="/device/kosmos_multi17/config", value="{\"name\":\"kosmos_multi17\",\"schema\":\"https://kosmos-lab.de/schema/MultiSensor.json\",\"state\":{\"currentEnvironmentTemperature\":17,\"humidityLevel\":10},\"scopes\":{\"read\":\"kosmos:read\",\"write\":\"kosmos:write\",\"del\":\"kosmos:del\"}}"), @ExampleObject(name="/device/lamp1/config", value="{\"name\":\"lamp1\",\"schema\":\"https://kosmos-lab.de/schema/Lamp.json\",\"state\":{\"on\":true}}")}))}, parameters={@Parameter(description="the uuid of the device you want to control", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/state", publishMessages={@Message(name="device/state", payloadSchema={@Schema(type=SchemaType.OBJECT, description="the state of the given device", examples={@ExampleObject(name="changed temperature for heating", value="{\"heatingTemperatureSetting\":20.5}"), @ExampleObject(name="updated rgb color", value="{\"color\":{\"r\":255,\"g\":0,\"b\":255}}"), @ExampleObject(name="turned off ", value="{\"on\":false}"), @ExampleObject(name="turned off HomeAssistant device", value="{\"state\":\"OFF\"}")})})}, parameters={@Parameter(description="the uuid of the device", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)}), @Channel(userLevel=1, tags={@Tag(name="KosmoS")}, path="device/{uuid}/location", publishMessages={@Message(name="device/location", payloadSchema={@Schema(ref="/doc/openapi.yaml#/components/schemas/deviceLocation")})}, parameters={@Parameter(description="the uuid of the device the location refers to", name="uuid", schema=@Schema(type=SchemaType.STRING), in=ParameterIn.PATH)})})
@WebSocket
public class KosmoSWebSocketService
extends WebSocketService
implements CommandInterface,
EventInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"KosmoSWebSocketService");
    private final IController controller;
    private final ConcurrentHashMap<Session, IUser> logins = new ConcurrentHashMap();
    private final ConcurrentHashMap<Session, String> types = new ConcurrentHashMap();
    private final WebSocketService.Pinger pinger;
    public ConcurrentHashMap<String, MessageTimer> messageTimers = new ConcurrentHashMap();
    ConcurrentHashMap<IUser, HashSet<Device>> ignoredDevices = new ConcurrentHashMap();

    public KosmoSWebSocketService(KosmoSWebServer server, IController c) {
        super((WebServer)server);
        this.controller = c;
        this.pinger = new WebSocketService.Pinger((WebSocketService)this);
        this.pinger.start();
        this.controller.addCommandInterface(this);
        this.controller.addEventInterface(this);
    }

    private CommandSourceName getSourceName(Session session) {
        return this.controller.getSource("WebSocket" + session.getLocalAddress().toString());
    }

    private CommandSourceName getSourceName(Session session, String pre) {
        return this.controller.getSource(pre + "WebSocket" + session.getLocalAddress().toString());
    }

    public void broadCast(String text) {
        this.broadCast(text, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadCast(String text, Session sess) {
        ConcurrentHashMap<Session, IUser> concurrentHashMap = this.logins;
        synchronized (concurrentHashMap) {
            for (Map.Entry<Session, IUser> e : this.logins.entrySet()) {
                if (e.getValue() == null || sess == e.getKey()) continue;
                try {
                    e.getKey().getRemote().sendString(text);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void broadcastToReadUsers(Device device, String text, CommandSourceName source) {
        this.broadcastToReadUsers(device, text, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToReadUsers(Device device, String text, CommandSourceName source, Session sourceSession) {
        ConcurrentHashMap<Session, IUser> concurrentHashMap = this.logins;
        synchronized (concurrentHashMap) {
            for (Map.Entry<Session, IUser> e : this.logins.entrySet()) {
                try {
                    IUser user = e.getValue();
                    if (user == null || !device.canRead(user)) continue;
                    try {
                        String type;
                        if (source != null && source.getSourceName().startsWith("haset") && ("HAIntegration".equals(type = this.types.get(e.getKey())) || user.getName().equalsIgnoreCase("ha"))) {
                            logger.trace("SKIPPING broadcast, because it came from HASET in the first place");
                            continue;
                        }
                        if (sourceSession != null && sourceSession == e.getKey()) continue;
                        e.getKey().getRemote().sendString(text);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (NoAccessToScope noAccessToScope) {}
            }
        }
    }

    @Override
    public void deviceAdded(CommandInterface from, Device device, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/config:" + device.toJSON(), source);
    }

    @Override
    public void deviceRemoved(CommandInterface from, Device device, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/config:", source);
    }

    @Override
    public void deviceUpdate(CommandInterface from, Device device, String key, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/state:" + device, source);
    }

    @Override
    public void eventFired(@Nullable EventInterface from, @Nonnull Event event) {
        this.eventFired(from, event, null);
    }

    public void eventFired(@Nullable EventInterface from, @Nonnull Event event, Session sourceSession) {
        if (from != this) {
            if (event.getDevice() != null) {
                this.broadcastToReadUsers(event.getDevice(), String.format("device/%s/event:%s", event.getDevice().getUniqueID(), event.toJSON().toString()), null, sourceSession);
            } else {
                this.broadCast(String.format("event:%s", event.toJSON().toString()), sourceSession);
            }
        }
    }

    @Override
    public void stop() {
        for (Session s : this.sessions) {
            try {
                s.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void delWebSocketClient(Session sess) {
        super.delWebSocketClient(sess);
        this.logins.remove(sess);
    }

    @OnWebSocketMessage
    public void onWebSocketMessage(Session sess, String message) {
        block99: {
            IUser user = this.logins.get(sess);
            if (user != null) {
                String type = this.types.get(sess);
                if (type != null) {
                    logger.info("Received TEXT message: {} from: {} {} ({}) ", new Object[]{message, sess, user.getName(), type});
                } else {
                    logger.info("Received TEXT message: {} from: {} {} ", new Object[]{message, sess, user.getName()});
                }
            } else {
                logger.info("Received TEXT message: {} from {}", (Object)message, (Object)sess);
            }
            if (message.equalsIgnoreCase("ping")) {
                try {
                    sess.getRemote().sendString("pong");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            Matcher m = Constants.websocketSplitPattern.matcher(message);
            if (m.matches()) {
                String topic = m.group(1);
                if (topic == null) {
                    return;
                }
                if (topic.startsWith("kosmos/")) {
                    topic = topic.substring(7);
                }
                if (topic.startsWith("device/")) {
                    topic = topic.substring(7);
                }
                String payload = m.group(2);
                if (topic.equals("user/auth") || topic.equals("user/login")) {
                    block98: {
                        JSONObject json = new JSONObject(payload);
                        String usern = json.optString("user");
                        String pass = json.optString("pass");
                        if (usern != null && pass != null) {
                            IUser u = null;
                            try {
                                u = this.controller.tryLogin(usern, pass);
                                if (u != null) {
                                    this.logins.put(sess, u);
                                    logger.info("auth successful");
                                    this.afterAuth(sess, u);
                                    return;
                                }
                                break block98;
                            }
                            catch (LoginFailedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        logger.warn("json not correct");
                    }
                    try {
                        logger.warn("json auth failed!");
                        sess.getRemote().sendString("auth failed");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (topic.equals("user/token")) {
                    if (payload != null && !payload.equals("null")) {
                        try {
                            JSONObject o = this.controller.getJwt().verify(payload);
                            IUser u = this.controller.getUser(o.getInt("id"));
                            this.logins.put(sess, u);
                            logger.info("auth successful");
                            sess.getRemote().sendString("auth successful");
                            this.afterAuth(sess, u);
                            return;
                        }
                        catch (InvalidKeyException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (JWT.JWTVerifyFailed e) {
                            e.printStackTrace();
                        }
                        catch (UserNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        logger.info("token auth failed!");
                        sess.getRemote().sendString("auth failed");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (topic.equals("user/type")) {
                    this.types.put(sess, payload);
                } else if (user != null) {
                    JSONObject json2;
                    Device d;
                    String uuid;
                    if (topic.equals("kree/stdout")) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)"log");
                            obj.put("value", (Object)payload);
                            RulesService s = this.controller.getRulesService();
                            if (s != null) {
                                s.broadcastToUser(this.logins.get(sess), obj.toString());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.equals("kree/stderr")) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)"error");
                            obj.put("value", (Object)payload);
                            RulesService s = this.controller.getRulesService();
                            if (s != null) {
                                s.broadcastToUser(this.logins.get(sess), obj.toString());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.equals("locations")) {
                        try {
                            for (Device device : this.controller.getAllDevices()) {
                                try {
                                    Device.Location loc;
                                    if (!device.canRead(user) || (loc = device.getLocation()) == null) continue;
                                    sess.getRemote().sendString("device/" + device.getUniqueID() + "/location:" + loc.toJSON().toString());
                                }
                                catch (NoAccessToScope loc) {}
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.endsWith("/set")) {
                        uuid = topic.substring(0, topic.length() - 4);
                        try {
                            JSONObject pl = new JSONObject();
                            try {
                                pl = new JSONObject(payload);
                            }
                            catch (JSONException loc) {
                                // empty catch block
                            }
                            String type = this.types.get(sess);
                            if (type != null && type.equals("HAIntegration")) {
                                this.controller.parseHASet(this, uuid, pl, this.getSourceName(sess, "haset/"), user);
                                return;
                            }
                            this.controller.parseSet((CommandInterface)this, uuid, pl, this.getSourceName(sess), user);
                        }
                        catch (DeviceNotFoundException | NoAccessToScope e) {
                            logger.warn(e.getMessage());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (topic.endsWith("/haset")) {
                        int c;
                        MessageTimer mt = this.messageTimers.get(topic);
                        if (mt == null) {
                            mt = new MessageTimer();
                            this.messageTimers.put(topic, mt);
                        }
                        if ((c = mt.count()) > 3) {
                            return;
                        }
                        mt.addEntry();
                        String uuid2 = topic.substring(0, topic.length() - 6);
                        try {
                            JSONObject p = new JSONObject(payload);
                            if (!p.has("state")) {
                                p.put("state", (Object)new JSONObject());
                            }
                            this.controller.parseHASet(this, uuid2, p, this.getSourceName(sess, "haset/"), user);
                        }
                        catch (DeviceNotFoundException | NoAccessToScope ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                        catch (JSONException ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                        catch (Exception ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                    } else if (topic.endsWith("/setname")) {
                        uuid = topic.substring(0, topic.length() - 8);
                        d = null;
                        try {
                            d = this.controller.getDevice(uuid);
                            this.controller.setName(d, payload);
                        }
                        catch (DeviceNotFoundException e) {
                            e.printStackTrace();
                        }
                    } else if (topic.endsWith("/config")) {
                        try {
                            if (payload.length() > 2) {
                                this.controller.parseAddDevice(this, new JSONObject(payload), this.getSourceName(sess), user);
                                break block99;
                            }
                            uuid = topic.substring(0, topic.length() - 7);
                            d = this.controller.getDevice(uuid);
                            if (d == null) break block99;
                            try {
                                if (d.canDel(user)) {
                                    this.controller.deleteDevice(this, d);
                                }
                            }
                            catch (NoAccessToScope e) {
                                e.printStackTrace();
                            }
                        }
                        catch (DeviceAlreadyExistsException uuid3) {
                        }
                        catch (SchemaNotFoundException | ParameterNotFoundException e) {
                            logger.warn(e.getMessage());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (topic.endsWith("/location")) {
                        try {
                            json2 = new JSONObject(payload);
                            if (!json2.has("uuid")) {
                                json2.put("uuid", (Object)topic.substring(0, topic.length() - 9));
                            }
                            this.controller.setLocation(user, json2, this.getSourceName(sess));
                        }
                        catch (DeviceNotFoundException json2) {
                        }
                        catch (ParameterNotFoundException e) {
                            logger.warn(e.getMessage());
                        }
                        catch (NoAccessToScope noAccessToScope) {
                            noAccessToScope.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (topic.equals("event")) {
                        try {
                            json2 = new JSONObject(payload);
                            Event event = new Event(this.controller, this, json2, null);
                            this.controller.fireEvent(event, this);
                            this.eventFired(this, event, sess);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (topic.endsWith("/event")) {
                        try {
                            json2 = new JSONObject(payload);
                            d = this.controller.getDevice(topic.substring(0, topic.length() - 6));
                            if (d.canRead(user)) {
                                Event event = new Event(this.controller, this, json2, d);
                                this.controller.fireEvent(event, this);
                                this.eventFired(this, event, sess);
                            }
                        }
                        catch (DeviceNotFoundException json3) {
                        }
                        catch (NoAccessToScope noAccessToScope) {
                            noAccessToScope.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    logger.warn("user is NOT authed!");
                }
            }
        }
    }

    public void addIgnoredDevice(IUser user, Device device) {
        HashSet<Device> set = this.ignoredDevices.get(user);
        if (set == null) {
            set = new HashSet();
            this.ignoredDevices.put(user, set);
        }
        set.add(device);
    }

    private void afterAuth(Session sess, IUser u) {
        try {
            sess.getRemote().sendString("auth successful");
            HashSet<DataSchema> schemas = new HashSet<DataSchema>();
            JSONArray arr = new JSONArray();
            HashSet<Device> set = this.ignoredDevices.get(u);
            for (Device device : this.controller.getAllDevices()) {
                try {
                    if (!device.canRead(u)) continue;
                    schemas.add(device.getDataSchema());
                    JSONObject d = device.toJSON();
                    if (device.canWriteReadOnly(u)) {
                        d.put("canWriteReadOnly", true);
                    }
                    if (set != null && set.contains((Object)device) && d.has("state")) {
                        d.remove("state");
                    }
                    arr.put((Object)d);
                }
                catch (NoAccessToScope d) {}
            }
            JSONObject s = new JSONObject();
            for (DataSchema schema : schemas) {
                s.put(schema.getSchema().getId(), (Object)schema.getRawSchema());
            }
            sess.getRemote().sendString("schemas:" + s);
            sess.getRemote().sendString("devices:" + arr);
            return;
        }
        catch (Exception e) {
            logger.warn("Exception:", (Throwable)e);
            return;
        }
    }

    @Override
    public String getSourceName() {
        return "HTTPApi";
    }

    public void ping() {
        this.broadCast("ping");
    }

    private static class MessageTimerEntry {
        public long aliveUntil = System.currentTimeMillis() + 1000L;
    }

    private static class MessageTimer {
        public ConcurrentLinkedQueue<MessageTimerEntry> entries = new ConcurrentLinkedQueue();

        private MessageTimer() {
        }

        public void addEntry() {
            this.entries.add(new MessageTimerEntry());
        }

        public int count() {
            long now = System.currentTimeMillis();
            int c = 0;
            for (MessageTimerEntry e : this.entries) {
                if (e.aliveUntil <= now) {
                    this.entries.remove(e);
                    continue;
                }
                ++c;
            }
            return c;
        }
    }
}

