/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.group;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.exceptions.NoAccessToGroup;
import de.kosmos_lab.platform.exceptions.NotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import jakarta.servlet.http.HttpServletResponse;

@ApiEndpoint(path="/group/delete", userLevel=1)
public class GroupDeleteServlet
extends KosmoSAuthedServlet {
    private static final String FIELD_GROUP = "group";

    public GroupDeleteServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"group"}, summary="delete", description="Delete a Group from the system.", parameters={@Parameter(description="The name of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="group", schema=@Schema(type=SchemaType.STRING), required=true)}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The group was deleted successfully.")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws NoAccessToGroup, NotFoundException, ParameterNotFoundException, UnauthorizedException {
        String groupname = request.getString(FIELD_GROUP);
        Group group = this.controller.getGroup(groupname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
        if (group.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
            this.controller.delGroup(group);
            response.setStatus(204);
            return;
        }
        throw new NoAccessToGroup(group);
    }
}

