/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.group;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiEndpoint(path="/group/my", userLevel=1)
public class GroupMyServlet
extends KosmoSAuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_ADMIN = "admin";

    public GroupMyServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"group"}, summary="my", description="Lists the scopes you have access to", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="A JSONObject stating the groups you have access to", content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="admin", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the groups you have admin access to"))), @SchemaProperty(name="user", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the groups you have user access to")))})})})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, UnauthorizedException {
        JSONObject o = new JSONObject();
        JSONArray arr = new JSONArray();
        for (Group group : this.controller.getAllGroupsWithUser(request.getKosmoSUser())) {
            arr.put((Object)group.getName());
        }
        o.put(FIELD_USER, (Object)arr);
        arr = new JSONArray();
        for (Group group : this.controller.getAllGroupsWithAdmin(request.getKosmoSUser())) {
            arr.put((Object)group.getName());
        }
        o.put(FIELD_ADMIN, (Object)arr);
        GroupMyServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)o);
    }
}

