/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.openid;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSServlet;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

@ApiEndpoint(path="/openid/callback/web")
public class CallbackWebServlet
extends KosmoSServlet {
    public static final String path = "/openid/callback/web";

    public CallbackWebServlet(KosmoSWebServer webServer, IController controller) {
        super(webServer, controller);
    }

    @Override
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws UnauthorizedException, ParameterNotFoundException {
        UUID uuid = UUID.fromString(request.getString("state"));
        IUser u = this.server.processKC(request.getString("code"), uuid);
        if (u != null) {
            try {
                String token = this.controller.getJwt().sign(u.toJWT());
                String redirect = this.server.getRedirectTo(uuid);
                redirect = redirect != null ? (redirect.contains("?") ? String.format("window.location.replace(\"%s&token=%s\")", redirect, token) : String.format("window.location.replace(\"%s?token=%s\")", redirect, token)) : "";
                CallbackWebServlet.sendHTML((BaseServletRequest)request, (HttpServletResponse)response, (String)String.format("<html><script>window.localStorage.setItem('token',\"%s\");%s</script><body>You are now logged in, please close this window and reload the service you wanted to access</html>", token, redirect));
                return;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                logger.warn("error while taking auth", (Throwable)e);
            }
        }
        response.setStatus(403);
    }
}

