/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.bazhenov.docker.AfterContainerStart;
import me.bazhenov.docker.Container;
import me.bazhenov.docker.ContainerDefinition;
import me.bazhenov.docker.ContainerNamespace;
import me.bazhenov.docker.ContainerPort;
import me.bazhenov.docker.ContainersFrom;
import me.bazhenov.docker.NotificationMethod;
import me.bazhenov.docker.Port;
import me.bazhenov.docker.PortRef;
import me.bazhenov.docker.Volume;
import me.bazhenov.docker.VolumeDef;

public class DockerAnnotationsInspector {
    private Map<Class<?>, ContainerNamespace> namespaces = new HashMap();

    public ContainerNamespace createNamespace(Class<?> clazz) {
        ContainerNamespace existingNamespace = this.namespaces.get(clazz);
        if (existingNamespace != null) {
            return existingNamespace;
        }
        Container[] local = (Container[])clazz.getAnnotationsByType(Container.class);
        ContainersFrom imports = clazz.getAnnotation(ContainersFrom.class);
        if (local.length <= 0 && imports == null) {
            return null;
        }
        HashMap<String, ContainerDefinition> result = new HashMap<String, ContainerDefinition>();
        for (Container a : local) {
            ContainerDefinition def = DockerAnnotationsInspector.createContainerDefinitionFromAnnotation(a);
            if (result.containsKey(a.name())) {
                throw new IllegalStateException("Duplicating container name: " + a.name() + " for test: " + clazz);
            }
            result.put(a.name(), def);
        }
        ArrayList<ContainerNamespace> importNamespaces = new ArrayList<ContainerNamespace>();
        if (imports != null) {
            for (Class<?> aClass : imports.value()) {
                importNamespaces.add(this.createNamespace(aClass));
            }
        }
        ContainerNamespace namespace = new ContainerNamespace(result, importNamespaces);
        this.namespaces.put(clazz, namespace);
        return namespace;
    }

    private static ContainerDefinition createContainerDefinitionFromAnnotation(Container annotation) {
        ContainerDefinition def = new ContainerDefinition(annotation.image(), annotation.command());
        DockerAnnotationsInspector.fillPublishedPorts(annotation, def);
        DockerAnnotationsInspector.fillEnvironmentVariables(annotation, def);
        DockerAnnotationsInspector.fillCustomOptions(annotation, def);
        DockerAnnotationsInspector.fillVolumes(annotation, def);
        def.setRemoveAfterCompletion(annotation.removeAfterCompletion());
        def.setWaitForAllExposedPortsToBeOpen(annotation.waitForAllExposedPorts());
        def.setNetwork(annotation.network());
        def.setNetworkAlias(annotation.networkAlias());
        if (!annotation.workingDir().isEmpty()) {
            def.setWorkingDirectory(annotation.workingDir());
        }
        return def;
    }

    private static void fillVolumes(Container annotation, ContainerDefinition def) {
        for (Volume vDef : annotation.volumes()) {
            File atHost = vDef.atHost().isEmpty() ? null : new File(vDef.atHost());
            def.addVolume(new VolumeDef(vDef.value(), atHost, vDef.createDirectoryIfMissing()));
        }
    }

    private static void fillEnvironmentVariables(Container annotation, ContainerDefinition def) {
        for (String value : annotation.environment()) {
            String[] parts = value.split("=", 2);
            def.addEnvironment(parts[0], parts[1]);
        }
    }

    private static void fillPublishedPorts(Container annotation, ContainerDefinition def) {
        for (Port port : annotation.publish()) {
            def.addPublishedPort(port.value(), port.atHost());
        }
    }

    private static void fillCustomOptions(Container annotation, ContainerDefinition def) {
        for (String option : annotation.options()) {
            def.addCustomOption(option);
        }
    }

    public Collection<ContainerNamespace> getAllNamespaces() {
        return this.namespaces.values();
    }

    public Optional<NotificationMethod> resolveNotificationMethod(Class<?> clazz) {
        ContainerNamespace namespace = this.namespaces.get(clazz);
        if (namespace == null) {
            return Optional.empty();
        }
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(AfterContainerStart.class) == null) continue;
            DockerAnnotationsInspector.ensureParameterTypes(method);
            ArrayList<PortRef> portReferences = new ArrayList<PortRef>(method.getParameterCount());
            for (Annotation[] args : method.getParameterAnnotations()) {
                ContainerPort portRef = this.retrieveAnnotation(args);
                if (portRef == null) {
                    throw new IllegalStateException("All parameters should be marked with @ContainerPort: " + method);
                }
                portReferences.add(new PortRef(namespace.getDefinition(portRef.name()), portRef.port()));
            }
            return Optional.of(new NotificationMethod(namespace, method, portReferences));
        }
        return Optional.empty();
    }

    private ContainerPort retrieveAnnotation(Annotation[] args) {
        for (Annotation a : args) {
            if (!(a instanceof ContainerPort)) continue;
            return (ContainerPort)a;
        }
        return null;
    }

    private static void ensureParameterTypes(Method method) {
        for (Class<?> type : method.getParameterTypes()) {
            if (type == Integer.TYPE) continue;
            throw new IllegalStateException("All method parameters should be of type int: " + method);
        }
    }
}

