/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.exceptions.SingularMatrixException;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface CommonMatrix3DBasics
extends Matrix3DReadOnly,
Clearable {
    public void set(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    default public void set(Orientation3DReadOnly orientation3D) {
        if (orientation3D instanceof RotationMatrixReadOnly) {
            this.set((RotationMatrixReadOnly)orientation3D);
        } else {
            orientation3D.get(this);
        }
    }

    default public void set(RotationMatrixReadOnly rotationMatrix) {
        this.set((Matrix3DReadOnly)rotationMatrix);
    }

    @Override
    default public void setToZero() {
        this.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    default public void setToNaN() {
        this.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return Matrix3DReadOnly.super.containsNaN();
    }

    default public void normalize() {
        Matrix3DTools.normalize(this);
    }

    default public void invert() {
        boolean success = Matrix3DTools.invert(this);
        if (!success) {
            throw new SingularMatrixException(this);
        }
    }

    default public void transpose() {
        this.set(this.getM00(), this.getM10(), this.getM20(), this.getM01(), this.getM11(), this.getM21(), this.getM02(), this.getM12(), this.getM22());
    }

    default public void setIdentity() {
        this.set(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    default public void set(Matrix3DReadOnly other) {
        this.set(other.getM00(), other.getM01(), other.getM02(), other.getM10(), other.getM11(), other.getM12(), other.getM20(), other.getM21(), other.getM22());
    }

    default public void setAndInvert(Matrix3DReadOnly other) {
        this.set(other);
        this.invert();
    }

    default public void setAndTranspose(Matrix3DReadOnly other) {
        this.set(other);
        this.transpose();
    }

    default public void set(double[] matrixArray) {
        double m00 = matrixArray[0];
        double m01 = matrixArray[1];
        double m02 = matrixArray[2];
        double m10 = matrixArray[3];
        double m11 = matrixArray[4];
        double m12 = matrixArray[5];
        double m20 = matrixArray[6];
        double m21 = matrixArray[7];
        double m22 = matrixArray[8];
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    default public void set(int startIndex, double[] matrixArray) {
        double m00 = matrixArray[startIndex + 0];
        double m01 = matrixArray[startIndex + 1];
        double m02 = matrixArray[startIndex + 2];
        double m10 = matrixArray[startIndex + 3];
        double m11 = matrixArray[startIndex + 4];
        double m12 = matrixArray[startIndex + 5];
        double m20 = matrixArray[startIndex + 6];
        double m21 = matrixArray[startIndex + 7];
        double m22 = matrixArray[startIndex + 8];
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    default public void set(DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(3, 3, (Matrix)matrix);
        double m00 = matrix.unsafe_get(0, 0);
        double m01 = matrix.unsafe_get(0, 1);
        double m02 = matrix.unsafe_get(0, 2);
        double m10 = matrix.unsafe_get(1, 0);
        double m11 = matrix.unsafe_get(1, 1);
        double m12 = matrix.unsafe_get(1, 2);
        double m20 = matrix.unsafe_get(2, 0);
        double m21 = matrix.unsafe_get(2, 1);
        double m22 = matrix.unsafe_get(2, 2);
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    default public void set(int startRow, int startColumn, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 3, startColumn + 3, (Matrix)matrix);
        int row = startRow;
        int column = startColumn;
        double m00 = matrix.unsafe_get(row, column++);
        double m01 = matrix.unsafe_get(row, column++);
        double m02 = matrix.unsafe_get(row, column);
        column = startColumn;
        double m10 = matrix.unsafe_get(++row, column++);
        double m11 = matrix.unsafe_get(row, column++);
        double m12 = matrix.unsafe_get(row, column);
        column = startColumn;
        double m20 = matrix.unsafe_get(++row, column++);
        double m21 = matrix.unsafe_get(row, column++);
        double m22 = matrix.unsafe_get(row, column);
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    default public void setAndNormalize(Matrix3DReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public void setRows(Tuple3DReadOnly firstRow, Tuple3DReadOnly secondRow, Tuple3DReadOnly thirdRow) {
        this.set(firstRow.getX(), firstRow.getY(), firstRow.getZ(), secondRow.getX(), secondRow.getY(), secondRow.getZ(), thirdRow.getX(), thirdRow.getY(), thirdRow.getZ());
    }

    default public void setColumns(Tuple3DReadOnly firstColumn, Tuple3DReadOnly secondColumn, Tuple3DReadOnly thirdColumn) {
        this.set(firstColumn.getX(), secondColumn.getX(), thirdColumn.getX(), firstColumn.getY(), secondColumn.getY(), thirdColumn.getY(), firstColumn.getZ(), secondColumn.getZ(), thirdColumn.getZ());
    }
}

