/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface Vector2DReadOnly
extends Tuple2DReadOnly {
    default public double length() {
        return EuclidCoreTools.squareRoot(this.lengthSquared());
    }

    default public double lengthSquared() {
        return this.dot(this);
    }

    default public double dot(Vector2DReadOnly other) {
        return this.getX() * other.getX() + this.getY() * other.getY();
    }

    default public double angle(Vector2DReadOnly other) {
        double firstVectorX = this.getX();
        double firstVectorY = this.getY();
        double secondVectorX = other.getX();
        double secondVectorY = other.getY();
        double crossProduct = firstVectorX * secondVectorY - firstVectorY * secondVectorX;
        double dotProduct = firstVectorX * secondVectorX + firstVectorY * secondVectorY;
        return EuclidCoreTools.atan2(crossProduct, dotProduct);
    }

    default public double cross(Tuple2DReadOnly tuple) {
        return Vector2DReadOnly.cross(this, tuple);
    }

    public static double cross(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getY() - tuple1.getY() * tuple2.getX();
    }

    default public boolean geometricallyEquals(Vector2DReadOnly other, double epsilon) {
        double dy;
        double dx = this.getX() - other.getX();
        return EuclidCoreTools.norm(dx, dy = this.getY() - other.getY()) <= epsilon;
    }
}

