/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface BoundingBox2DBasics
extends BoundingBox2DReadOnly,
Clearable {
    public Point2DBasics getMinPoint();

    public Point2DBasics getMaxPoint();

    @Override
    default public boolean containsNaN() {
        return BoundingBox2DReadOnly.super.containsNaN();
    }

    default public void setMin(Point2DReadOnly min) {
        this.getMinPoint().set((Tuple2DReadOnly)min);
        this.checkBounds();
    }

    default public void setMin(double[] min) {
        this.getMinPoint().set(min);
        this.checkBounds();
    }

    default public void setMin(double minX, double minY) {
        this.getMinPoint().set(minX, minY);
        this.checkBounds();
    }

    default public void setMax(Point2DReadOnly max) {
        this.getMaxPoint().set((Tuple2DReadOnly)max);
        this.checkBounds();
    }

    default public void setMax(double[] max) {
        this.getMaxPoint().set(max);
        this.checkBounds();
    }

    default public void setMax(double maxX, double maxY) {
        this.getMaxPoint().set(maxX, maxY);
        this.checkBounds();
    }

    default public void set(double minX, double minY, double maxX, double maxY) {
        this.getMinPoint().set(minX, minY);
        this.getMaxPoint().set(maxX, maxY);
        this.checkBounds();
    }

    default public void set(double[] min, double[] max) {
        this.getMinPoint().set(min);
        this.getMaxPoint().set(max);
        this.checkBounds();
    }

    default public void set(Point2DReadOnly min, Point2DReadOnly max) {
        this.getMinPoint().set((Tuple2DReadOnly)min);
        this.getMaxPoint().set((Tuple2DReadOnly)max);
        this.checkBounds();
    }

    default public void set(Point2DReadOnly center, Vector2DReadOnly halfSize) {
        this.getMinPoint().sub((Tuple2DReadOnly)center, (Tuple2DReadOnly)halfSize);
        this.getMaxPoint().add((Tuple2DReadOnly)center, (Tuple2DReadOnly)halfSize);
        this.checkBounds();
    }

    default public void set(BoundingBox2DReadOnly other) {
        this.getMinPoint().set((Tuple2DReadOnly)other.getMinPoint());
        this.getMaxPoint().set((Tuple2DReadOnly)other.getMaxPoint());
    }

    default public void combine(BoundingBox2DReadOnly other) {
        this.combine(this, other);
    }

    default public void combine(BoundingBox2DReadOnly boundingBoxOne, BoundingBox2DReadOnly boundingBoxTwo) {
        double minX = Double.isNaN(boundingBoxOne.getMinX()) ? boundingBoxTwo.getMinX() : (Double.isNaN(boundingBoxTwo.getMinX()) ? boundingBoxOne.getMinX() : Math.min(boundingBoxOne.getMinX(), boundingBoxTwo.getMinX()));
        double minY = Double.isNaN(boundingBoxOne.getMinY()) ? boundingBoxTwo.getMinY() : (Double.isNaN(boundingBoxTwo.getMinY()) ? boundingBoxOne.getMinY() : Math.min(boundingBoxOne.getMinY(), boundingBoxTwo.getMinY()));
        double maxX = Double.isNaN(boundingBoxOne.getMaxX()) ? boundingBoxTwo.getMaxX() : (Double.isNaN(boundingBoxTwo.getMaxX()) ? boundingBoxOne.getMaxX() : Math.max(boundingBoxOne.getMaxX(), boundingBoxTwo.getMaxX()));
        double maxY = Double.isNaN(boundingBoxOne.getMaxY()) ? boundingBoxTwo.getMaxY() : (Double.isNaN(boundingBoxTwo.getMaxY()) ? boundingBoxOne.getMaxY() : Math.max(boundingBoxOne.getMaxY(), boundingBoxTwo.getMaxY()));
        this.set(minX, minY, maxX, maxY);
    }

    default public void setToNaN() {
        this.getMinPoint().setToNaN();
        this.getMaxPoint().setToNaN();
    }

    default public void setToZero() {
        this.getMinPoint().setToZero();
        this.getMaxPoint().setToZero();
    }

    default public void updateToIncludePoints(Vertex2DSupplier vertex2DSupplier) {
        for (int index = 0; index < vertex2DSupplier.getNumberOfVertices(); ++index) {
            this.updateToIncludePoint(vertex2DSupplier.getVertex(index));
        }
    }

    default public void updateToIncludePoint(Point2DReadOnly point) {
        this.updateToIncludePoint(point.getX(), point.getY());
    }

    default public void updateToIncludePoint(double x, double y) {
        if (Double.isNaN(this.getMinPoint().getX()) || x < this.getMinPoint().getX()) {
            this.getMinPoint().setX(x);
        }
        if (Double.isNaN(this.getMinPoint().getY()) || y < this.getMinPoint().getY()) {
            this.getMinPoint().setY(y);
        }
        if (Double.isNaN(this.getMaxPoint().getX()) || x > this.getMaxPoint().getX()) {
            this.getMaxPoint().setX(x);
        }
        if (Double.isNaN(this.getMaxPoint().getY()) || y > this.getMaxPoint().getY()) {
            this.getMaxPoint().setY(y);
        }
    }
}

