/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Line3DBasics
extends Line3DReadOnly,
Transformable,
Clearable {
    public Point3DBasics getPoint();

    public UnitVector3DBasics getDirection();

    default public boolean containsNaN() {
        return this.getPoint().containsNaN() || this.getDirection().containsNaN();
    }

    default public void setToZero() {
        this.getPoint().setToZero();
        this.getDirection().set((UnitVector3DReadOnly)Axis3D.X);
    }

    default public void setToNaN() {
        this.getPoint().setToNaN();
        this.getDirection().setToNaN();
    }

    @Deprecated
    default public void negateDirection() {
        this.getDirection().negate();
    }

    @Deprecated
    default public void setPoint(double pointOnLineX, double pointOnLineY, double pointOnLineZ) {
        this.getPoint().set(pointOnLineX, pointOnLineY, pointOnLineZ);
    }

    @Deprecated
    default public void setPoint(Point3DReadOnly pointOnLine) {
        this.getPoint().set((Tuple3DReadOnly)pointOnLine);
    }

    @Deprecated
    default public void setDirection(double lineDirectionX, double lineDirectionY, double lineDirectionZ) {
        this.getDirection().set(lineDirectionX, lineDirectionY, lineDirectionZ);
    }

    @Deprecated
    default public void setDirection(Vector3DReadOnly lineDirection) {
        this.getDirection().set((Tuple3DReadOnly)lineDirection);
    }

    default public void set(Line2DReadOnly line2DReadOnly) {
        this.getPoint().set((Tuple2DReadOnly)line2DReadOnly.getPoint(), 0.0);
        this.getDirection().set((Tuple2DReadOnly)line2DReadOnly.getDirection(), 0.0);
    }

    default public void set(Line3DReadOnly other) {
        this.getPoint().set((Tuple3DReadOnly)other.getPoint());
        this.getDirection().set(other.getDirection());
    }

    default public void set(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.set(lineSegment2DReadOnly.getFirstEndpoint(), lineSegment2DReadOnly.getSecondEndpoint());
    }

    default public void set(LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.set(lineSegment3DReadOnly.getFirstEndpoint(), lineSegment3DReadOnly.getSecondEndpoint());
    }

    default public void set(double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ) {
        this.getPoint().set(pointOnLineX, pointOnLineY, pointOnLineZ);
        this.getDirection().set(lineDirectionX, lineDirectionY, lineDirectionZ);
    }

    default public void set(Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        if (firstPointOnLine.equals((Tuple2DReadOnly)secondPointOnLine)) {
            throw new RuntimeException("Tried to create a line from two coincidal points");
        }
        this.getPoint().set((Tuple2DReadOnly)firstPointOnLine, 0.0);
        this.getDirection().set((Tuple2DReadOnly)secondPointOnLine, 0.0);
        this.getDirection().subX(firstPointOnLine.getX());
        this.getDirection().subY(firstPointOnLine.getY());
    }

    default public void set(Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine) {
        if (firstPointOnLine.equals((Tuple3DReadOnly)secondPointOnLine)) {
            throw new RuntimeException("Tried to create a line from two coincidal points");
        }
        this.getPoint().set((Tuple3DReadOnly)firstPointOnLine);
        this.getDirection().sub((Tuple3DReadOnly)secondPointOnLine, (Tuple3DReadOnly)firstPointOnLine);
    }

    default public void set(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        this.getPoint().set((Tuple2DReadOnly)pointOnLine, 0.0);
        this.getDirection().set((Tuple2DReadOnly)lineDirection, 0.0);
    }

    default public void set(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        this.getPoint().set((Tuple3DReadOnly)pointOnLine);
        this.getDirection().set((Tuple3DReadOnly)lineDirection);
    }

    default public void translate(double x, double y, double z) {
        this.getPoint().add(x, y, z);
    }

    default public void applyTransform(Transform transform) {
        this.getPoint().applyTransform(transform);
        this.getDirection().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getPoint().applyInverseTransform(transform);
        this.getDirection().applyInverseTransform(transform);
    }
}

