/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Triangle3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;

public class EuclidGeometryTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidGeometryTestTools() {
    }

    public static void assertLine2DEquals(Line2DReadOnly expected, Line2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine2DEquals(null, expected, actual, epsilon);
    }

    public static void assertLine2DEquals(String messagePrefix, Line2DReadOnly expected, Line2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLine2DEquals(String messagePrefix, Line2DReadOnly expected, Line2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLine2DGeometricallyEquals(Line2DReadOnly expected, Line2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertLine2DGeometricallyEquals(String messagePrefix, Line2DReadOnly expected, Line2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLine2DGeometricallyEquals(String messagePrefix, Line2DReadOnly expected, Line2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLine3DEquals(Line3DReadOnly expected, Line3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine3DEquals(null, expected, actual, epsilon);
    }

    public static void assertLine3DEquals(String messagePrefix, Line3DReadOnly expected, Line3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLine3DEquals(String messagePrefix, Line3DReadOnly expected, Line3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLine3DGeometricallyEquals(Line3DReadOnly expected, Line3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertLine3DGeometricallyEquals(String messagePrefix, Line3DReadOnly expected, Line3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLine3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLine3DGeometricallyEquals(String messagePrefix, Line3DReadOnly expected, Line3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment1DEquals(LineSegment1D expected, LineSegment1D actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment1DEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment1DEquals(String messagePrefix, LineSegment1D expected, LineSegment1D actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment1DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment1DEquals(String messagePrefix, LineSegment1D expected, LineSegment1D actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment1DGeometricallyEquals(LineSegment1D expected, LineSegment1D actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment1DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment1DGeometricallyEquals(String messagePrefix, LineSegment1D expected, LineSegment1D actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment1DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment1DGeometricallyEquals(String messagePrefix, LineSegment1D expected, LineSegment1D actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment2DEquals(LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment2DEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment2DEquals(String messagePrefix, LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment2DEquals(String messagePrefix, LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment2DGeometricallyEquals(LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment2DGeometricallyEquals(String messagePrefix, LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment2DGeometricallyEquals(String messagePrefix, LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment3DEquals(LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment3DEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment3DEquals(String messagePrefix, LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment3DEquals(String messagePrefix, LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertLineSegment3DGeometricallyEquals(LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertLineSegment3DGeometricallyEquals(String messagePrefix, LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertLineSegment3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertLineSegment3DGeometricallyEquals(String messagePrefix, LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertBoundingBox2DEquals(BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox2DEquals(null, expected, actual, epsilon);
    }

    public static void assertBoundingBox2DEquals(String messagePrefix, BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertBoundingBox2DEquals(String messagePrefix, BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertBoundingBox2DGeometricallyEquals(BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertBoundingBox2DGeometricallyEquals(String messagePrefix, BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertBoundingBox2DGeometricallyEquals(String messagePrefix, BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertBoundingBox3DEquals(BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox3DEquals(null, expected, actual, epsilon);
    }

    public static void assertBoundingBox3DEquals(String messagePrefix, BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertBoundingBox3DEquals(String messagePrefix, BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertBoundingBox3DGeometricallyEquals(BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertBoundingBox3DGeometricallyEquals(String messagePrefix, BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertBoundingBox3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertBoundingBox3DGeometricallyEquals(String messagePrefix, BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    @Deprecated
    public static void assertOrientation2DEquals(Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation2DEquals((Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon);
    }

    @Deprecated
    public static void assertOrientation2DEquals(String messagePrefix, Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation2DEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon);
    }

    @Deprecated
    public static void assertOrientation2DEquals(String messagePrefix, Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon, String format) {
        EuclidCoreTestTools.assertOrientation2DEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon, (String)format);
    }

    @Deprecated
    public static void assertOrientation2DGeometricallyEquals(Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation2DGeometricallyEquals((Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon);
    }

    @Deprecated
    public static void assertOrientation2DGeometricallyEquals(String messagePrefix, Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation2DGeometricallyEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon);
    }

    @Deprecated
    public static void assertOrientation2DGeometricallyEquals(String messagePrefix, Orientation2DReadOnly expected, Orientation2DReadOnly actual, double epsilon, String format) {
        EuclidCoreTestTools.assertOrientation2DGeometricallyEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertPlane3DEquals(Plane3D expected, Plane3D actual, double epsilon) {
        EuclidGeometryTestTools.assertPlane3DEquals(null, expected, actual, epsilon);
    }

    public static void assertPlane3DEquals(String messagePrefix, Plane3D expected, Plane3D actual, double epsilon) {
        EuclidGeometryTestTools.assertPlane3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPlane3DEquals(String messagePrefix, Plane3D expected, Plane3D actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertPlane3DGeometricallyEquals(Plane3D expected, Plane3D actual, double epsilon) {
        EuclidGeometryTestTools.assertPlane3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertPlane3DGeometricallyEquals(String messagePrefix, Plane3D expected, Plane3D actual, double epsilon) {
        EuclidGeometryTestTools.assertPlane3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPlane3DGeometricallyEquals(String messagePrefix, Plane3D expected, Plane3D actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertPose2DEquals(Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose2DEquals(null, expected, actual, epsilon);
    }

    public static void assertPose2DEquals(String messagePrefix, Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPose2DEquals(String messagePrefix, Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertPose2DGeometricallyEquals(Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertPose2DGeometricallyEquals(String messagePrefix, Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPose2DGeometricallyEquals(String messagePrefix, Pose2DReadOnly expected, Pose2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertPose3DEquals(Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose3DEquals(null, expected, actual, epsilon);
    }

    public static void assertPose3DEquals(String messagePrefix, Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPose3DEquals(String messagePrefix, Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertPose3DGeometricallyEquals(Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertPose3DGeometricallyEquals(String messagePrefix, Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertPose3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPose3DGeometricallyEquals(String messagePrefix, Pose3DReadOnly expected, Pose3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertConvexPolygon2DEquals(ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertConvexPolygon2DEquals(null, expected, actual, epsilon);
    }

    public static void assertConvexPolygon2DEquals(String messagePrefix, ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertConvexPolygon2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertConvexPolygon2DEquals(String messagePrefix, ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertConvexPolygon2DGeometricallyEquals(ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertConvexPolygon2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertConvexPolygon2DGeometricallyEquals(String messagePrefix, ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertConvexPolygon2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertConvexPolygon2DGeometricallyEquals(String messagePrefix, ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertTriangle3DEquals(Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertTriangle3DEquals(null, expected, actual, epsilon);
    }

    public static void assertTriangle3DEquals(String messagePrefix, Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertTriangle3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertTriangle3DEquals(String messagePrefix, Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertTriangle3DGeometricallyEquals(Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertTriangle3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertTriangle3DGeometricallyEquals(String messagePrefix, Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon) {
        EuclidGeometryTestTools.assertTriangle3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertTriangle3DGeometricallyEquals(String messagePrefix, Triangle3DReadOnly expected, Triangle3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidGeometryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Line2DReadOnly expected, Line2DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getLine2DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getLine2DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Line3DReadOnly expected, Line3DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getLine3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getLine3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, LineSegment1D expected, LineSegment1D actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getLineSegment1DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getLineSegment1DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, LineSegment2DReadOnly expected, LineSegment2DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getLineSegment2DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getLineSegment2DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, LineSegment3DReadOnly expected, LineSegment3DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getLineSegment3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getLineSegment3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getBoundingBox2DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getBoundingBox2DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getBoundingBox3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getBoundingBox3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Plane3D expected, Plane3D actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getPlane3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getPlane3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Pose2DReadOnly expected, Pose2DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getPose2DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getPose2DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Pose3DReadOnly expected, Pose3DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getPose3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getPose3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, ConvexPolygon2DReadOnly expected, ConvexPolygon2DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getConvexPolygon2DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getConvexPolygon2DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, Triangle3DReadOnly expected, Triangle3DReadOnly actual, String format) {
        String expectedAsString = EuclidGeometryIOTools.getTriangle3DString(format, expected);
        String actualAsString = EuclidGeometryIOTools.getTriangle3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }
}

