/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.time;

import java.util.function.DoubleSupplier;
import us.ihmc.commons.Conversions;

public class Stopwatch {
    private final DoubleSupplier nowSupplier;
    private double lapStart;
    private long lapCount;
    private double recordedLapTotal;
    private boolean suspended;
    private double suspendStart;
    private double resumedSuspensionTotal;

    public Stopwatch() {
        this.nowSupplier = () -> Conversions.nanosecondsToSeconds(System.nanoTime());
        this.lapStart = Double.NaN;
    }

    public Stopwatch start() {
        this.reset();
        return this;
    }

    public void resetLap() {
        this.lapStart = this.now();
        this.resetSuspension();
    }

    public void reset() {
        this.lapStart = this.now();
        this.resetSuspension();
        this.lapCount = 0L;
        this.recordedLapTotal = 0.0;
    }

    public double lap() {
        double now = this.now();
        double lapDuration = this.lapElapsed(now);
        this.lapStart = now;
        this.resetSuspension();
        ++this.lapCount;
        this.recordedLapTotal += lapDuration;
        return lapDuration;
    }

    public double averageLap() {
        return this.recordedLapTotal / (double)this.lapCount;
    }

    public double totalElapsed() {
        return this.recordedLapTotal + this.lapElapsed(this.now());
    }

    public double lapElapsed() {
        return this.lapElapsed(this.now());
    }

    public void suspend() {
        if (!this.suspended) {
            this.suspended = true;
            this.suspendStart = this.now();
        }
    }

    public void resume() {
        if (this.suspended) {
            this.suspended = false;
            this.resumedSuspensionTotal += this.now() - this.suspendStart;
        }
    }

    private double lapElapsed(double now) {
        double lapElapsed = now - this.lapStart;
        lapElapsed -= this.resumedSuspensionTotal;
        if (this.suspended) {
            lapElapsed -= now - this.suspendStart;
        }
        return lapElapsed;
    }

    private double now() {
        return this.nowSupplier.getAsDouble();
    }

    private void resetSuspension() {
        this.suspended = false;
        this.resumedSuspensionTotal = 0.0;
    }

    Stopwatch(DoubleSupplier nowSupplier) {
        this.nowSupplier = nowSupplier;
        this.lapStart = Double.NaN;
    }
}

