/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.time;

import us.ihmc.commons.MathTools;

public interface TimeIntervalReadOnly {
    public double getStartTime();

    public double getEndTime();

    default public double getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    default public boolean epsilonEquals(TimeIntervalReadOnly other, double epsilon) {
        return MathTools.epsilonEquals(this.getStartTime(), other.getStartTime(), epsilon) && MathTools.epsilonEquals(this.getEndTime(), other.getEndTime(), epsilon);
    }

    default public boolean intervalContains(double time) {
        return MathTools.intervalContains(time, this.getStartTime(), this.getEndTime());
    }

    default public boolean epsilonContains(double time, double epsilon) {
        return MathTools.intervalContains(time, this.getStartTime() - epsilon, this.getEndTime() + epsilon);
    }

    default public void checkInterval() {
        TimeIntervalReadOnly.checkInterval(this);
    }

    public static void checkInterval(TimeIntervalReadOnly timeInterval) {
        if (timeInterval.getEndTime() < timeInterval.getStartTime()) {
            throw new IllegalArgumentException("The end time is not valid! End time " + timeInterval.getEndTime() + " must be greater than start time " + timeInterval.getStartTime());
        }
    }
}

