/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bramp.ffmpeg.nut.Frame;
import net.bramp.ffmpeg.nut.MainHeaderPacket;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.NutReaderListener;
import net.bramp.ffmpeg.nut.Packet;
import net.bramp.ffmpeg.nut.Stream;
import net.bramp.ffmpeg.nut.StreamHeaderPacket;

public class NutReader {
    static final byte[] HEADER = new byte[]{110, 117, 116, 47, 109, 117, 108, 116, 105, 109, 101, 100, 105, 97, 32, 99, 111, 110, 116, 97, 105, 110, 101, 114, 0};
    public MainHeaderPacket header;
    public final List<Stream> streams = new ArrayList<Stream>();
    final NutDataInputStream in;
    final NutReaderListener listener;

    public NutReader(InputStream in, NutReaderListener listener) {
        this.in = new NutDataInputStream(in);
        this.listener = (NutReaderListener)Preconditions.checkNotNull((Object)listener);
    }

    public static boolean isKnownStartcode(long startcode) {
        return Packet.Startcode.of(startcode) != null;
    }

    protected void readFileId() throws IOException {
        byte[] b = new byte[HEADER.length];
        this.in.readFully(b);
        if (!Arrays.equals(b, HEADER)) {
            throw new IOException("file_id_string does not match. got: " + new String(b, Charsets.ISO_8859_1));
        }
    }

    protected long readReservedHeaders() throws IOException {
        long startcode = this.in.readStartCode();
        while (Packet.Startcode.isPossibleStartcode(startcode) && NutReader.isKnownStartcode(startcode)) {
            new Packet().read(this.in, startcode);
            startcode = this.in.readStartCode();
        }
        return startcode;
    }

    public void read() throws IOException {
        this.readFileId();
        this.in.resetCRC();
        long startcode = this.in.readStartCode();
        block2: while (true) {
            this.header = new MainHeaderPacket();
            if (!Packet.Startcode.MAIN.equalsCode(startcode)) {
                throw new IOException(String.format("expected main header found: 0x%X", startcode));
            }
            this.header.read(this.in, startcode);
            startcode = this.readReservedHeaders();
            this.streams.clear();
            for (int i = 0; i < this.header.streamCount; ++i) {
                if (!Packet.Startcode.STREAM.equalsCode(startcode)) {
                    throw new IOException(String.format("expected stream header found: 0x%X", startcode));
                }
                StreamHeaderPacket streamHeader = new StreamHeaderPacket();
                streamHeader.read(this.in, startcode);
                Stream stream = new Stream(this.header, streamHeader);
                this.streams.add(stream);
                this.listener.stream(stream);
                startcode = this.readReservedHeaders();
            }
            while (Packet.Startcode.INFO.equalsCode(startcode)) {
                new Packet().read(this.in, startcode);
                startcode = this.readReservedHeaders();
            }
            if (Packet.Startcode.INDEX.equalsCode(startcode)) {
                new Packet().read(this.in, startcode);
                startcode = this.in.readStartCode();
            }
            while (true) {
                if (Packet.Startcode.MAIN.equalsCode(startcode)) continue block2;
                if (Packet.Startcode.SYNCPOINT.equalsCode(startcode)) {
                    new Packet().read(this.in, startcode);
                    startcode = this.in.readStartCode();
                }
                if (Packet.Startcode.isPossibleStartcode(startcode)) {
                    throw new IOException("expected framecode, found " + Packet.Startcode.toString(startcode));
                }
                Frame f = new Frame();
                f.read(this, this.in, (int)startcode);
                this.listener.frame(f);
                try {
                    startcode = this.readReservedHeaders();
                }
                catch (EOFException e) {
                    return;
                }
            }
            break;
        }
    }
}

