/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.CameraInfoPubSubType;
import sensor_msgs.msg.dds.RegionOfInterest;
import sensor_msgs.msg.dds.RegionOfInterestPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class CameraInfo
extends Packet<CameraInfo>
implements Settable<CameraInfo>,
EpsilonComparable<CameraInfo> {
    public Header header_ = new Header();
    public long height_;
    public long width_;
    public StringBuilder distortion_model_ = new StringBuilder(255);
    public IDLSequence.Double d_ = new IDLSequence.Double(100, "type_6");
    public double[] k_ = new double[9];
    public double[] r_ = new double[9];
    public double[] p_ = new double[12];
    public long binning_x_;
    public long binning_y_;
    public RegionOfInterest roi_ = new RegionOfInterest();

    public CameraInfo() {
    }

    public CameraInfo(CameraInfo other) {
        this();
        this.set(other);
    }

    public void set(CameraInfo other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.height_ = other.height_;
        this.width_ = other.width_;
        this.distortion_model_.setLength(0);
        this.distortion_model_.append((CharSequence)other.distortion_model_);
        this.d_.set(other.d_);
        for (int i1 = 0; i1 < this.k_.length; ++i1) {
            this.k_[i1] = other.k_[i1];
        }
        for (int i3 = 0; i3 < this.r_.length; ++i3) {
            this.r_[i3] = other.r_[i3];
        }
        for (int i5 = 0; i5 < this.p_.length; ++i5) {
            this.p_[i5] = other.p_[i5];
        }
        this.binning_x_ = other.binning_x_;
        this.binning_y_ = other.binning_y_;
        RegionOfInterestPubSubType.staticCopy(other.roi_, this.roi_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setHeight(long height) {
        this.height_ = height;
    }

    public long getHeight() {
        return this.height_;
    }

    public void setWidth(long width) {
        this.width_ = width;
    }

    public long getWidth() {
        return this.width_;
    }

    public void setDistortionModel(String distortion_model) {
        this.distortion_model_.setLength(0);
        this.distortion_model_.append(distortion_model);
    }

    public String getDistortionModelAsString() {
        return this.getDistortionModel().toString();
    }

    public StringBuilder getDistortionModel() {
        return this.distortion_model_;
    }

    public IDLSequence.Double getD() {
        return this.d_;
    }

    public double[] getK() {
        return this.k_;
    }

    public double[] getR() {
        return this.r_;
    }

    public double[] getP() {
        return this.p_;
    }

    public void setBinningX(long binning_x) {
        this.binning_x_ = binning_x;
    }

    public long getBinningX() {
        return this.binning_x_;
    }

    public void setBinningY(long binning_y) {
        this.binning_y_ = binning_y;
    }

    public long getBinningY() {
        return this.binning_y_;
    }

    public RegionOfInterest getRoi() {
        return this.roi_;
    }

    public static Supplier<CameraInfoPubSubType> getPubSubType() {
        return CameraInfoPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return CameraInfoPubSubType::new;
    }

    public boolean epsilonEquals(CameraInfo other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.height_, (double)other.height_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.width_, (double)other.width_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.distortion_model_, (StringBuilder)other.distortion_model_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsDoubleSequence((IDLSequence.Double)this.d_, (IDLSequence.Double)other.d_, (double)epsilon)) {
            return false;
        }
        for (int i7 = 0; i7 < this.k_.length; ++i7) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.k_[i7], (double)other.k_[i7], (double)epsilon)) continue;
            return false;
        }
        for (int i9 = 0; i9 < this.r_.length; ++i9) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.r_[i9], (double)other.r_[i9], (double)epsilon)) continue;
            return false;
        }
        for (int i11 = 0; i11 < this.p_.length; ++i11) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.p_[i11], (double)other.p_[i11], (double)epsilon)) continue;
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.binning_x_, (double)other.binning_x_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.binning_y_, (double)other.binning_y_, (double)epsilon)) {
            return false;
        }
        return this.roi_.epsilonEquals(other.roi_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof CameraInfo)) {
            return false;
        }
        CameraInfo otherMyClass = (CameraInfo)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (this.height_ != otherMyClass.height_) {
            return false;
        }
        if (this.width_ != otherMyClass.width_) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.distortion_model_, (StringBuilder)otherMyClass.distortion_model_)) {
            return false;
        }
        if (!this.d_.equals((Object)otherMyClass.d_)) {
            return false;
        }
        for (int i13 = 0; i13 < this.k_.length; ++i13) {
            if (this.k_[i13] == otherMyClass.k_[i13]) continue;
            return false;
        }
        for (int i15 = 0; i15 < this.r_.length; ++i15) {
            if (this.r_[i15] == otherMyClass.r_[i15]) continue;
            return false;
        }
        for (int i17 = 0; i17 < this.p_.length; ++i17) {
            if (this.p_[i17] == otherMyClass.p_[i17]) continue;
            return false;
        }
        if (this.binning_x_ != otherMyClass.binning_x_) {
            return false;
        }
        if (this.binning_y_ != otherMyClass.binning_y_) {
            return false;
        }
        return this.roi_.equals((Object)otherMyClass.roi_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CameraInfo {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("height=");
        builder.append(this.height_);
        builder.append(", ");
        builder.append("width=");
        builder.append(this.width_);
        builder.append(", ");
        builder.append("distortion_model=");
        builder.append((CharSequence)this.distortion_model_);
        builder.append(", ");
        builder.append("d=");
        builder.append(this.d_);
        builder.append(", ");
        builder.append("k=");
        builder.append(Arrays.toString(this.k_));
        builder.append(", ");
        builder.append("r=");
        builder.append(Arrays.toString(this.r_));
        builder.append(", ");
        builder.append("p=");
        builder.append(Arrays.toString(this.p_));
        builder.append(", ");
        builder.append("binning_x=");
        builder.append(this.binning_x_);
        builder.append(", ");
        builder.append("binning_y=");
        builder.append(this.binning_y_);
        builder.append(", ");
        builder.append("roi=");
        builder.append((Object)this.roi_);
        builder.append("}");
        return builder.toString();
    }
}

