/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.QuaternionPubSubType;
import geometry_msgs.msg.dds.Vector3PubSubType;
import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.ImuPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class Imu
extends Packet<Imu>
implements Settable<Imu>,
EpsilonComparable<Imu> {
    public Header header_ = new Header();
    public Quaternion orientation_ = new Quaternion();
    public double[] orientation_covariance_ = new double[9];
    public Vector3D angular_velocity_ = new Vector3D();
    public double[] angular_velocity_covariance_ = new double[9];
    public Vector3D linear_acceleration_ = new Vector3D();
    public double[] linear_acceleration_covariance_ = new double[9];

    public Imu() {
    }

    public Imu(Imu other) {
        this();
        this.set(other);
    }

    public void set(Imu other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        QuaternionPubSubType.staticCopy(other.orientation_, this.orientation_);
        for (int i1 = 0; i1 < this.orientation_covariance_.length; ++i1) {
            this.orientation_covariance_[i1] = other.orientation_covariance_[i1];
        }
        Vector3PubSubType.staticCopy(other.angular_velocity_, this.angular_velocity_);
        for (int i3 = 0; i3 < this.angular_velocity_covariance_.length; ++i3) {
            this.angular_velocity_covariance_[i3] = other.angular_velocity_covariance_[i3];
        }
        Vector3PubSubType.staticCopy(other.linear_acceleration_, this.linear_acceleration_);
        for (int i5 = 0; i5 < this.linear_acceleration_covariance_.length; ++i5) {
            this.linear_acceleration_covariance_[i5] = other.linear_acceleration_covariance_[i5];
        }
    }

    public Header getHeader() {
        return this.header_;
    }

    public Quaternion getOrientation() {
        return this.orientation_;
    }

    public double[] getOrientationCovariance() {
        return this.orientation_covariance_;
    }

    public Vector3D getAngularVelocity() {
        return this.angular_velocity_;
    }

    public double[] getAngularVelocityCovariance() {
        return this.angular_velocity_covariance_;
    }

    public Vector3D getLinearAcceleration() {
        return this.linear_acceleration_;
    }

    public double[] getLinearAccelerationCovariance() {
        return this.linear_acceleration_covariance_;
    }

    public static Supplier<ImuPubSubType> getPubSubType() {
        return ImuPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return ImuPubSubType::new;
    }

    public boolean epsilonEquals(Imu other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!this.orientation_.epsilonEquals(other.orientation_, epsilon)) {
            return false;
        }
        for (int i7 = 0; i7 < this.orientation_covariance_.length; ++i7) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.orientation_covariance_[i7], (double)other.orientation_covariance_[i7], (double)epsilon)) continue;
            return false;
        }
        if (!this.angular_velocity_.epsilonEquals(other.angular_velocity_, epsilon)) {
            return false;
        }
        for (int i9 = 0; i9 < this.angular_velocity_covariance_.length; ++i9) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.angular_velocity_covariance_[i9], (double)other.angular_velocity_covariance_[i9], (double)epsilon)) continue;
            return false;
        }
        if (!this.linear_acceleration_.epsilonEquals(other.linear_acceleration_, epsilon)) {
            return false;
        }
        for (int i11 = 0; i11 < this.linear_acceleration_covariance_.length; ++i11) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.linear_acceleration_covariance_[i11], (double)other.linear_acceleration_covariance_[i11], (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Imu)) {
            return false;
        }
        Imu otherMyClass = (Imu)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.orientation_.equals((Tuple4DReadOnly)otherMyClass.orientation_)) {
            return false;
        }
        for (int i13 = 0; i13 < this.orientation_covariance_.length; ++i13) {
            if (this.orientation_covariance_[i13] == otherMyClass.orientation_covariance_[i13]) continue;
            return false;
        }
        if (!this.angular_velocity_.equals((Tuple3DReadOnly)otherMyClass.angular_velocity_)) {
            return false;
        }
        for (int i15 = 0; i15 < this.angular_velocity_covariance_.length; ++i15) {
            if (this.angular_velocity_covariance_[i15] == otherMyClass.angular_velocity_covariance_[i15]) continue;
            return false;
        }
        if (!this.linear_acceleration_.equals((Tuple3DReadOnly)otherMyClass.linear_acceleration_)) {
            return false;
        }
        for (int i17 = 0; i17 < this.linear_acceleration_covariance_.length; ++i17) {
            if (this.linear_acceleration_covariance_[i17] == otherMyClass.linear_acceleration_covariance_[i17]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Imu {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("orientation=");
        builder.append(this.orientation_);
        builder.append(", ");
        builder.append("orientation_covariance=");
        builder.append(Arrays.toString(this.orientation_covariance_));
        builder.append(", ");
        builder.append("angular_velocity=");
        builder.append(this.angular_velocity_);
        builder.append(", ");
        builder.append("angular_velocity_covariance=");
        builder.append(Arrays.toString(this.angular_velocity_covariance_));
        builder.append(", ");
        builder.append("linear_acceleration=");
        builder.append(this.linear_acceleration_);
        builder.append(", ");
        builder.append("linear_acceleration_covariance=");
        builder.append(Arrays.toString(this.linear_acceleration_covariance_));
        builder.append("}");
        return builder.toString();
    }
}

