/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.affinity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.affinity.Processor;
import us.ihmc.affinity.SysFSTools;

public class Core {
    private final int id;
    private final ArrayList<Processor> processors = new ArrayList();

    public Core(int cpuID) {
        this.id = cpuID;
        try {
            String siblingStrings = SysFSTools.readFirstLine("/sys/devices/system/cpu/cpu" + cpuID + "/topology/thread_siblings_list");
            for (int id : SysFSTools.range(siblingStrings)) {
                this.processors.add(new Processor(id));
            }
        }
        catch (IOException | NumberFormatException e) {
            this.processors.add(new Processor(cpuID));
        }
    }

    public boolean isThreadSibling(int sibling) {
        for (Processor processor : this.processors) {
            if (sibling != processor.getId()) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfProcessors() {
        return this.processors.size();
    }

    public List<Processor> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public Processor getProcessor(int processor) {
        return this.processors.get(processor);
    }

    public Processor getDefaultProcessor() {
        return this.processors.get(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\t\tPhysical core: ");
        builder.append(this.id);
        builder.append('\n');
        for (Processor processor : this.processors) {
            builder.append(processor.toString());
        }
        return builder.toString();
    }
}

