/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.concurrent.Builder;

public class ConcurrentCopier<T> {
    private static final int NEXT_OBJECT_TO_READ_MASK = 12;
    private static final int CURRENTLY_BEING_READ_MASK = 3;
    private static final int INITIAL_STATE = 12;
    public final T[] buffer;
    private int currentlyBeingWritten = -1;
    private final AtomicInteger state = new AtomicInteger();

    public ConcurrentCopier(Builder<? extends T> classBuilder) {
        this.buffer = new Object[3];
        for (int i = 0; i < 3; ++i) {
            this.buffer[i] = classBuilder.newInstance();
        }
        this.state.set(12);
    }

    public T getCopyForReading() {
        int nextObjectToRead;
        int newState;
        int currentState;
        do {
            if ((currentState = this.state.get()) != 12) continue;
            return null;
        } while (!this.state.compareAndSet(currentState, newState = currentState & 0xC | (nextObjectToRead = (currentState & 0xC) >> 2)));
        return this.buffer[nextObjectToRead];
    }

    private int getNextWriteIndex(int currentState) {
        switch (currentState) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 0;
            }
            case 12: {
                return 1;
            }
        }
        throw new RuntimeException("Invalid Copier State: " + currentState);
    }

    public T getCopyForWriting() {
        this.currentlyBeingWritten = this.getNextWriteIndex(this.state.get());
        return this.buffer[this.currentlyBeingWritten];
    }

    public void commit() {
        int newState;
        int currentState;
        while (!this.state.compareAndSet(currentState = this.state.get(), newState = currentState & 3 | this.currentlyBeingWritten << 2)) {
        }
    }
}

