/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent;

import us.ihmc.concurrent.Builder;
import us.ihmc.util.PaddedAtomicLong;
import us.ihmc.util.RealtimeTools;

public class ConcurrentRingBuffer<T> {
    private long writePosition = -1L;
    private long cachedMaxWritePosition = -1L;
    private final PaddedAtomicLong commitPosition = new PaddedAtomicLong(-1L);
    public volatile long p1;
    public volatile long p2;
    public volatile long p3;
    public volatile long p4;
    public volatile long p5;
    public volatile long p6;
    public volatile long p7 = 8L;
    private long readLimit = -1L;
    private long readPosition = -1L;
    private final PaddedAtomicLong consumerPosition = new PaddedAtomicLong(0L);
    public volatile long p8;
    public volatile long p9;
    public volatile long p10;
    public volatile long p11;
    public volatile long p12;
    public volatile long p13;
    public volatile long p14 = 15L;
    private final int capacity;
    private final int capacityMask;
    private T[] buffer;

    public ConcurrentRingBuffer(Builder<? extends T> classBuilder, int capacity) {
        if (capacity < 0) {
            throw new RuntimeException("Capacity < 0");
        }
        this.capacity = RealtimeTools.nextPowerOfTwo(capacity);
        this.capacityMask = this.capacity - 1;
        this.buffer = new Object[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            this.buffer[i] = classBuilder.newInstance();
        }
    }

    private T getObject(long position) {
        return this.buffer[(int)(position & (long)this.capacityMask)];
    }

    public T next() {
        ++this.writePosition;
        if (this.writePosition >= this.cachedMaxWritePosition) {
            this.cachedMaxWritePosition = this.consumerPosition.get() + (long)this.capacity;
            if (this.writePosition >= this.cachedMaxWritePosition) {
                --this.writePosition;
                return null;
            }
        }
        return this.getObject(this.writePosition);
    }

    public void commit() {
        this.commitPosition.set(this.writePosition);
    }

    public boolean poll() {
        this.readLimit = this.commitPosition.get();
        return this.readPosition < this.readLimit;
    }

    public T read() {
        if (this.readPosition >= this.readLimit) {
            return null;
        }
        ++this.readPosition;
        return this.getObject(this.readPosition);
    }

    public T peek() {
        if (this.readPosition >= this.readLimit) {
            return null;
        }
        return this.getObject(this.readPosition + 1L);
    }

    public void flush() {
        this.consumerPosition.set(this.readPosition);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long avoidPaddingRemoval() {
        return this.p1 + this.p2 + this.p3 + this.p4 + this.p5 + this.p6 + this.p7 + this.p8 + this.p9 + this.p10 + this.p11 + this.p12 + this.p13 + this.p14;
    }
}

