/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.Task;

public class SingleThreadedScheduler<C>
implements Runnable {
    private final List<? extends Task<C>> tasks;
    private final C masterContext;
    private final boolean[] tasksInitialized;
    private long tick;

    public SingleThreadedScheduler(Collection<? extends Task<C>> tasks, C masterContext) {
        this.tasks = new ArrayList<Task<C>>(tasks);
        this.masterContext = masterContext;
        this.tasksInitialized = new boolean[tasks.size()];
    }

    @Override
    public void run() {
        Task<C> task;
        int i;
        for (i = 0; i < this.tasks.size(); ++i) {
            task = this.tasks.get(i);
            if (!task.isPending(this.tick)) continue;
            task.updateLocalContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            task = this.tasks.get(i);
            if (!task.isPending(this.tick)) continue;
            if (!this.tasksInitialized[i]) {
                this.tasksInitialized[i] = task.initialize();
            }
            if (!this.tasksInitialized[i]) continue;
            task.execute();
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            task = this.tasks.get(i);
            if (!task.isPending(this.tick)) continue;
            task.updateMasterContext(this.masterContext);
        }
        ++this.tick;
    }

    public void shutdown() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            this.tasks.get(i).cleanup();
        }
    }
}

