/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.process;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LinuxProcess {
    private final int pid;
    private final String comm;
    private final String commandLine;

    private LinuxProcess(int pid, String comm, String commandLine) {
        this.pid = pid;
        this.comm = comm;
        this.commandLine = commandLine;
    }

    public String toString() {
        return "LinuxProcess [pid=" + this.pid + ", comm=" + this.comm + ", commandLine=" + this.commandLine + "]";
    }

    public int getPid() {
        return this.pid;
    }

    public String getComm() {
        return this.comm;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public static List<LinuxProcess> getProcesses() throws IOException {
        Path procFS = Paths.get("/proc", new String[0]);
        if (!Files.exists(procFS, new LinkOption[0])) {
            throw new IOException("/proc not found. This utility requires support for the /proc file system");
        }
        Pattern zero = Pattern.compile("\\u0000");
        Pattern unprintable = Pattern.compile("\\p{C}");
        ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
        for (int i = 1; i <= 32168; ++i) {
            List<String> commandLines;
            Path commandLineFile;
            Path processDir = procFS.resolve(String.valueOf(i));
            if (!Files.isDirectory(processDir, new LinkOption[0])) continue;
            int pid = i;
            String comm = null;
            String commandLine = null;
            Path commFile = processDir.resolve("comm");
            if (Files.exists(commFile, new LinkOption[0])) {
                List<String> commLines = Files.readAllLines(commFile);
                comm = commLines.get(0);
            }
            if (Files.exists(commandLineFile = processDir.resolve("cmdline"), new LinkOption[0]) && (commandLines = Files.readAllLines(commandLineFile)).size() > 0) {
                commandLine = zero.matcher(commandLines.get(0)).replaceAll(" ");
                commandLine = unprintable.matcher(commandLine).replaceAll("?");
            }
            LinuxProcess process = new LinuxProcess(pid, comm, commandLine);
            processes.add(process);
        }
        return processes;
    }

    public static List<LinuxProcess> getProcessesByPattern(String regex) throws IOException {
        Pattern p = Pattern.compile(regex);
        List<LinuxProcess> processes = LinuxProcess.getProcesses();
        ArrayList<LinuxProcess> matched = new ArrayList<LinuxProcess>();
        for (LinuxProcess process : processes) {
            if (!p.matcher(process.getComm()).matches()) continue;
            matched.add(process);
        }
        return matched;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(LinuxProcess.getProcessesByPattern("java"));
    }
}

