/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import us.ihmc.affinity.CPUTopology;
import us.ihmc.affinity.Package;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.tasks.BindingContext;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.tasks.CopyableContextTask;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.tasks.InPlaceCopyable;
import us.ihmc.realtime.CPUDMALatency;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.realtime.RealtimeThread;

public class TestBarrierSchedulerCyclic {
    private static final long SCHEDULER_PERIOD_NANOSECONDS = 500000L;
    private static final int NUM_ITERATIONS_OF_SCHEDULER = 120000;
    private static final double ESTIMATED_DURATION = 60.0;

    public static void main(String[] args) throws InterruptedException {
        final UpdateVariablesTask updateVariablesTask = new UpdateVariablesTask(2L);
        final ExamineVariablesTask examineVariablesTask = new ExamineVariablesTask(10L);
        PriorityParameters updateTaskPriority = new PriorityParameters(95);
        PriorityParameters examineVariablesPriority = new PriorityParameters(95);
        RealtimeThread examineThread = new RealtimeThread(examineVariablesPriority, examineVariablesTask, "examineTask");
        RealtimeThread updateThread = new RealtimeThread(updateTaskPriority, updateVariablesTask, "updateTask");
        Package cpuPackage = new CPUTopology().getPackage(0);
        CPUDMALatency.setLatency(0);
        System.out.println("Starting cyclic test [Iterations: 120000; Estimated Duration: 60.0s]");
        System.out.println("Pinning examine thread to core 2 and update thread to core 3.");
        examineThread.setAffinity(cpuPackage.getCore(2).getDefaultProcessor());
        updateThread.setAffinity(cpuPackage.getCore(3).getDefaultProcessor());
        examineThread.start();
        updateThread.start();
        List<CopyableContextTask> tasks = Arrays.asList(examineVariablesTask, updateVariablesTask);
        TestCyclicContext context = new TestCyclicContext(examineVariablesTask, updateVariablesTask);
        final BarrierScheduler<TestCyclicContext> barrierScheduler = new BarrierScheduler<TestCyclicContext>(tasks, context, BarrierScheduler.TaskOverrunBehavior.SKIP_TICK);
        PriorityParameters schedulerPriority = new PriorityParameters(99);
        PeriodicParameters periodicParameters = new PeriodicParameters(500000L);
        final TimingInformation schedulerTimingInformation = new TimingInformation("Scheduler", 500000L);
        RealtimeThread schedulerThread = new RealtimeThread(schedulerPriority, periodicParameters, "barrierSchedulerThread"){
            boolean firstTick;
            int iterations;
            {
                super(priorityParameters, periodicParameters, name);
                this.firstTick = true;
                this.iterations = -1;
            }

            @Override
            public void run() {
                while (this.iterations < 120000) {
                    super.waitForNextPeriod();
                    if (this.firstTick) {
                        schedulerTimingInformation.initialize(System.nanoTime());
                        this.firstTick = false;
                    } else {
                        schedulerTimingInformation.updateTimingInformation(System.nanoTime());
                    }
                    barrierScheduler.run();
                    ++this.iterations;
                }
                barrierScheduler.shutdown();
                updateVariablesTask.doReporting();
                examineVariablesTask.doReporting();
                System.out.format("Scheduler Jitter: avg = %.4f us, max = %.4f us%n", schedulerTimingInformation.getFinalAvgJitterMicroseconds(), schedulerTimingInformation.getFinalMaxJitterMicroseconds());
            }
        };
        System.out.println("Pinning scheduler thread to core 1");
        schedulerThread.setAffinity(cpuPackage.getCore(1).getDefaultProcessor());
        schedulerThread.start();
        schedulerThread.join();
        System.out.println("Thread done??");
    }

    private static class ExamineVariablesTask
    extends CopyableContextTask {
        final Random random = new Random(1976L);
        final TimingInformation timingInformation;
        final TestCyclicData cyclicData = new TestCyclicData();
        private int anInt;
        private long aLong;
        private float aFloat;
        private double aDouble;
        boolean firstTick = true;

        public ExamineVariablesTask(long divisor) {
            super(divisor);
            this.timingInformation = new TimingInformation("Examine Task", 500000L * divisor);
        }

        public void doReporting() {
            System.out.format("Examine Task Jitter: avg = %.4f us, max = %.4f us%n", this.timingInformation.getFinalAvgJitterMicroseconds(), this.timingInformation.getFinalMaxJitterMicroseconds());
        }

        @Override
        protected boolean initialize() {
            return true;
        }

        @Override
        protected void execute() {
            this.anInt = (int)((double)this.cyclicData.someInts[this.random.nextInt(this.cyclicData.someInts.length)] * this.random.nextDouble());
            this.aLong = (long)((double)this.cyclicData.someLongs[this.random.nextInt(this.cyclicData.someLongs.length)] * this.random.nextDouble());
            this.aFloat = (float)((double)this.cyclicData.someFloats[this.random.nextInt(this.cyclicData.someFloats.length)] * this.random.nextDouble());
            this.aDouble = this.cyclicData.someDoubles[this.random.nextInt(this.cyclicData.someDoubles.length)] * this.random.nextDouble();
            if (this.firstTick) {
                this.timingInformation.initialize(System.nanoTime());
                this.firstTick = false;
            } else {
                this.timingInformation.updateTimingInformation(System.nanoTime());
            }
        }

        @Override
        protected void cleanup() {
        }
    }

    private static class UpdateVariablesTask
    extends CopyableContextTask {
        private final Random random = new Random(1976L);
        private final TestCyclicData cyclicData = new TestCyclicData();
        private final TimingInformation timingInformation;
        boolean firstTick = true;

        public UpdateVariablesTask(long divisor) {
            super(divisor);
            this.timingInformation = new TimingInformation("Update Task", 500000L * divisor);
        }

        public void doReporting() {
            System.out.format("Update Task Jitter: avg = %.4f us, max = %.4f us%n", this.timingInformation.getFinalAvgJitterMicroseconds(), this.timingInformation.getFinalMaxJitterMicroseconds());
        }

        @Override
        protected boolean initialize() {
            return true;
        }

        @Override
        protected void execute() {
            int i;
            for (i = 0; i < this.cyclicData.someInts.length; ++i) {
                ((TestCyclicData)this.cyclicData).someInts[i] = this.random.nextInt();
            }
            for (i = 0; i < this.cyclicData.someLongs.length; ++i) {
                ((TestCyclicData)this.cyclicData).someLongs[i] = this.random.nextLong();
            }
            for (i = 0; i < this.cyclicData.someFloats.length; ++i) {
                ((TestCyclicData)this.cyclicData).someFloats[i] = this.random.nextFloat();
            }
            for (i = 0; i < this.cyclicData.someDoubles.length; ++i) {
                ((TestCyclicData)this.cyclicData).someDoubles[i] = this.random.nextDouble();
            }
            if (this.firstTick) {
                this.timingInformation.initialize(System.nanoTime());
                this.firstTick = false;
            } else {
                this.timingInformation.updateTimingInformation(System.nanoTime());
            }
        }

        @Override
        protected void cleanup() {
        }
    }

    public static class TestCyclicData
    implements InPlaceCopyable<TestCyclicData> {
        private final int[] someInts = new int[16];
        private final long[] someLongs = new long[8];
        private final float[] someFloats = new float[16];
        private final double[] someDoubles = new double[8];

        @Override
        public void copyFrom(TestCyclicData src) {
            System.arraycopy(src.someInts, 0, this.someInts, 0, this.someInts.length);
            System.arraycopy(src.someLongs, 0, this.someLongs, 0, this.someLongs.length);
            System.arraycopy(src.someFloats, 0, this.someFloats, 0, this.someFloats.length);
            System.arraycopy(src.someDoubles, 0, this.someDoubles, 0, this.someDoubles.length);
        }
    }

    private static class TimingInformation {
        long previousTime = 0L;
        long avgJitter = 0L;
        long maxJitter = 0L;
        long periodInNS;
        long iterations = 0L;

        TimingInformation(String name, long periodInNS) {
            this.periodInNS = periodInNS;
            System.out.println(name + " Period, Hz: " + 1.0 / ((double)periodInNS / 1.0E9));
        }

        public void initialize(long currentTime) {
            this.previousTime = currentTime;
        }

        public void updateTimingInformation(long newTime) {
            long jitter = Math.abs(newTime - this.previousTime - this.periodInNS);
            if (jitter > this.maxJitter) {
                this.maxJitter = jitter;
            }
            this.previousTime = newTime;
            this.avgJitter += jitter;
            ++this.iterations;
        }

        public double getFinalMaxJitterMicroseconds() {
            return (double)this.maxJitter / 1000.0;
        }

        public double getFinalAvgJitterMicroseconds() {
            return (double)this.avgJitter / (double)this.iterations / 1000.0;
        }
    }

    public static class TestCyclicContext
    extends BindingContext {
        public TestCyclicContext(ExamineVariablesTask examineVariablesTask, UpdateVariablesTask updateVariablesTask) {
            this.bind(updateVariablesTask.cyclicData, examineVariablesTask.cyclicData);
        }
    }
}

