/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.gesture;

import de.kosmos_lab.platform.gesture.QPointCloudRecognizer;
import de.kosmos_lab.platform.gesture.data.Gesture;
import de.kosmos_lab.platform.gesture.data.Point;
import de.kosmos_lab.utils.FileUtils;
import de.kosmos_lab.utils.StringFunctions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"})
public class GestureProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)"GestureProvider");
    public static final Pattern jsonMatcher = Pattern.compile("^(?<name>.*)_(?<key>[A-Za-z0-9]{26})\\.json$");
    private final String path;
    private final File dir;
    private final ConcurrentLinkedQueue<Gesture> gestures = new ConcurrentLinkedQueue();

    public GestureProvider(boolean readGestures, @Nonnull String path) {
        this.path = path;
        this.dir = new File(path);
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            logger.warn("could not create gesture folder \"{}\" - exiting", (Object)this.dir);
            System.exit(1);
        }
        if (readGestures) {
            for (GestureFile gf : this.getGestureFiles()) {
                try {
                    JSONArray points = new JSONArray(FileUtils.readFile((File)gf.file));
                    logger.info("Read gesture {}({}) with {} Points", new Object[]{gf.name, gf.key, points.length()});
                    Gesture g = new Gesture((Point[])this.readPoints(points).toArray(Point[]::new), gf.name, gf.key);
                    this.gestures.add(g);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            logger.info("Found {} gestures", (Object)this.gestures.size());
        }
    }

    public boolean addGesture(@Nonnull String name, @Nonnull JSONArray arr, boolean save, @Nonnull String key) {
        if (save) {
            this.saveGesture(name, arr, key);
        }
        Gesture g = new Gesture((Point[])this.readPoints(arr).toArray(Point[]::new), name, key);
        String newGesturePoints = g.pointsToJSON().toString();
        for (Gesture g2 : this.gestures) {
            String existingGesturePoints = g2.pointsToJSON().toString();
            if (!newGesturePoints.equals(existingGesturePoints)) continue;
            return false;
        }
        this.gestures.add(g);
        return true;
    }

    public boolean addGesture(@Nonnull String name, @Nonnull JSONArray arr, boolean save) {
        if (this.dir == null) {
            throw new IllegalArgumentException("Gesture directory not set");
        }
        boolean used = false;
        String key = null;
        block0: do {
            key = StringFunctions.generateRandomKey((int)26);
            File[] files = this.dir.listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (!f.getName().endsWith(key + ".json")) continue;
                used = true;
                continue block0;
            }
        } while (used);
        return this.addGesture(name, arr, save, key);
    }

    public void addGesture(@Nonnull Gesture g) {
        this.gestures.add(g);
    }

    public boolean deleteGesture(@Nonnull String id) {
        boolean found = false;
        for (Gesture g : this.gestures) {
            if (!g.Id.equals(id)) continue;
            this.gestures.remove(g);
            found = true;
            break;
        }
        for (GestureFile gf : this.getGestureFiles()) {
            if (!gf.key.equals(id)) continue;
            if (gf.file.exists() && !gf.file.delete()) {
                logger.warn("could not delete gesture file \"{}\"", (Object)gf.file);
            }
            found = true;
            break;
        }
        return found;
    }

    @Nonnull
    public Collection<GestureFile> getGestureFiles(@Nonnull String gesture) {
        LinkedList<GestureFile> list = new LinkedList<GestureFile>();
        for (GestureFile gf : this.getGestureFiles()) {
            if (!gf.name.equals(gesture)) continue;
            list.add(gf);
        }
        return list;
    }

    @Nonnull
    public Collection<GestureFile> getGestureFiles() {
        LinkedList<GestureFile> list = new LinkedList<GestureFile>();
        if (this.dir == null) {
            throw new IllegalArgumentException("Gesture directory not set");
        }
        File[] files = this.dir.listFiles();
        if (files != null) {
            for (File f : files) {
                Matcher m = jsonMatcher.matcher(f.getName());
                if (!m.matches()) continue;
                list.add(new GestureFile(m.group("name"), f, m.group("key")));
            }
        }
        return list;
    }

    @Nonnull
    public Collection<Gesture> listGestures() {
        return this.gestures;
    }

    @CheckForNull
    public Gesture predict(JSONArray arr) {
        return this.predict(new Gesture((Point[])this.readPoints(arr).toArray(Point[]::new)));
    }

    @CheckForNull
    public Gesture predict(@Nonnull Gesture gesture) {
        return QPointCloudRecognizer.Classify(gesture, this.gestures);
    }

    @Nonnull
    public LinkedList<Point> readPoints(@Nonnull JSONArray arr) {
        LinkedList<Point> pts = new LinkedList<Point>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONArray ptarr = arr.getJSONArray(i);
            for (int j = 0; j < ptarr.length(); ++j) {
                try {
                    Object o = ptarr.get(j);
                    if (o instanceof JSONArray) {
                        JSONArray a = ptarr.getJSONArray(j);
                        pts.add(new Point(Double.valueOf(a.getDouble(0)).floatValue(), Double.valueOf(a.getDouble(1)).floatValue(), i));
                        continue;
                    }
                    logger.warn("type of o is {} {}", o.getClass(), o);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return pts;
    }

    @Nonnull
    public boolean renameGesture(@Nonnull String from, @Nonnull String to) {
        boolean found = false;
        for (Gesture g : this.gestures) {
            if (!g.name.equals(from)) continue;
            File f = this.getGestureFile(g);
            g.name = to;
            File f2 = this.getGestureFile(g);
            if (!f.renameTo(f2)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Nonnull
    public File getGestureFile(@Nonnull String name, @Nonnull String key) {
        return new File(this.path + "/" + name + "_" + key + ".json");
    }

    @Nonnull
    public File getGestureFile(@Nonnull Gesture g) {
        return this.getGestureFile(g.name, g.Id);
    }

    public boolean saveGesture(@Nonnull String name, @Nonnull JSONArray arr, @Nonnull String key) {
        String str = arr.toString();
        boolean save = false;
        for (GestureFile gf : this.getGestureFiles()) {
            try {
                if (!FileUtils.readFile((File)gf.file).equals(str)) continue;
                save = false;
                logger.debug("skipping to save gesture, its already there");
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileUtils.writeToFile((File)this.getGestureFile(name, key), (String)str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void saveGesture(@Nonnull Gesture g) {
        this.saveGesture(g.name, g.pointsToJSON(), g.Id);
    }

    private static class GestureFile {
        protected final String name;
        protected final File file;
        protected final String key;

        private GestureFile(@Nonnull String name, @Nonnull File file, @Nonnull String key) {
            this.file = file;
            this.name = name;
            this.key = key;
        }
    }
}

